/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.FloatFloatProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.OpenFloatFloatHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenFloatFloatHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatFloatHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenFloatFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenFloatFloatHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenFloatFloatHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatFloatHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenFloatFloatHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        OpenFloatFloatHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenFloatFloatHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenFloatFloatHashMapTest.assertEquals((double)0.0, (double)map.get(11.0f), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        OpenFloatFloatHashMap map2 = (OpenFloatFloatHashMap)map.clone();
        map.clear();
        OpenFloatFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        OpenFloatFloatHashMapTest.assertTrue((boolean)map.containsKey(11.0f));
        OpenFloatFloatHashMapTest.assertFalse((boolean)map.containsKey(12.0f));
    }

    @Test
    public void testContainValue() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        OpenFloatFloatHashMapTest.assertTrue((boolean)map.containsValue(22.0f));
        OpenFloatFloatHashMapTest.assertFalse((boolean)map.containsValue(23.0f));
    }

    @Test
    public void testForEachKey() {
        final FloatArrayList keys = new FloatArrayList();
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        map.put(12.0f, 23.0f);
        map.put(13.0f, 24.0f);
        map.put(14.0f, 25.0f);
        map.removeKey(13.0f);
        map.forEachKey(new FloatProcedure(){

            public boolean apply(float element) {
                keys.add(element);
                return true;
            }
        });
        float[] keysArray = keys.toArray(new float[keys.size()]);
        Arrays.sort(keysArray);
        OpenFloatFloatHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        map.put(12.0f, 23.0f);
        map.put(13.0f, 24.0f);
        map.put(14.0f, 25.0f);
        map.removeKey(13.0f);
        map.forEachPair(new FloatFloatProcedure(){

            public boolean apply(float first, float second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenFloatFloatHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenFloatFloatHashMapTest.assertEquals((float)11.0f, (float)((Pair)pairs.get((int)0)).k, (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)22.0f, (float)((Pair)pairs.get((int)0)).v, (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)12.0f, (float)((Pair)pairs.get((int)1)).k, (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)23.0f, (float)((Pair)pairs.get((int)1)).v, (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)14.0f, (float)((Pair)pairs.get((int)2)).k, (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)25.0f, (float)((Pair)pairs.get((int)2)).v, (float)1.0E-6f);
        pairs.clear();
        map.forEachPair(new FloatFloatProcedure(){
            int count = 0;

            public boolean apply(float first, float second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenFloatFloatHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        map.put(12.0f, 23.0f);
        OpenFloatFloatHashMapTest.assertEquals((float)22.0f, (float)map.get(11.0f), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)0.0f, (float)map.get(0.0f), (float)1.0E-6f);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        map.put(12.0f, 23.0f);
        map.put(13.0f, 24.0f);
        map.put(14.0f, 25.0f);
        map.adjustOrPutValue(11.0f, 1.0f, 3.0f);
        OpenFloatFloatHashMapTest.assertEquals((float)25.0f, (float)map.get(11.0f), (float)1.0E-6f);
        map.adjustOrPutValue(15.0f, 1.0f, 3.0f);
        OpenFloatFloatHashMapTest.assertEquals((float)1.0f, (float)map.get(15.0f), (float)1.0E-6f);
    }

    @Test
    public void testKeys() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        map.put(12.0f, 22.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keys(keys);
        keys.sort();
        OpenFloatFloatHashMapTest.assertEquals((float)11.0f, (float)keys.get(0), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)12.0f, (float)keys.get(1), (float)1.0E-6f);
        FloatArrayList k2 = map.keys();
        k2.sort();
        OpenFloatFloatHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        FloatArrayList keyList = new FloatArrayList();
        FloatArrayList valueList = new FloatArrayList();
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        map.put(12.0f, 23.0f);
        map.put(13.0f, 24.0f);
        map.put(14.0f, 25.0f);
        map.removeKey(13.0f);
        map.pairsMatching(new FloatFloatProcedure(){

            public boolean apply(float first, float second) {
                return first % 2.0f == 0.0f;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenFloatFloatHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenFloatFloatHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenFloatFloatHashMapTest.assertEquals((float)12.0f, (float)keyList.get(0), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)14.0f, (float)keyList.get(1), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)23.0f, (float)valueList.get(0), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)25.0f, (float)valueList.get(1), (float)1.0E-6f);
    }

    @Test
    public void testValues() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        map.put(12.0f, 23.0f);
        map.put(13.0f, 24.0f);
        map.put(14.0f, 25.0f);
        map.removeKey(13.0f);
        FloatArrayList values = new FloatArrayList(100);
        map.values(values);
        OpenFloatFloatHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenFloatFloatHashMapTest.assertEquals((float)22.0f, (float)values.get(0), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)23.0f, (float)values.get(1), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)25.0f, (float)values.get(2), (float)1.0E-6f);
    }

    @Test
    public void testCopy() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        OpenFloatFloatHashMap map2 = (OpenFloatFloatHashMap)map.copy();
        map.clear();
        OpenFloatFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        map.put(12.0f, 23.0f);
        map.put(13.0f, 24.0f);
        map.put(14.0f, 25.0f);
        map.removeKey(13.0f);
        OpenFloatFloatHashMap map2 = (OpenFloatFloatHashMap)map.copy();
        OpenFloatFloatHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenFloatFloatHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenFloatFloatHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenFloatFloatHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0f);
        OpenFloatFloatHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenFloatFloatHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 22.0f);
        map.put(12.0f, 23.0f);
        map.put(13.0f, 24.0f);
        map.put(14.0f, 25.0f);
        map.removeKey(13.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keysSortedByValue(keys);
        float[] keysArray = keys.toArray(new float[keys.size()]);
        OpenFloatFloatHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenFloatFloatHashMap map = new OpenFloatFloatHashMap();
        map.put(11.0f, 100.0f);
        map.put(12.0f, 70.0f);
        map.put(13.0f, 30.0f);
        map.put(14.0f, 3.0f);
        FloatArrayList keys = new FloatArrayList();
        FloatArrayList values = new FloatArrayList();
        map.pairsSortedByKey(keys, values);
        OpenFloatFloatHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenFloatFloatHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenFloatFloatHashMapTest.assertEquals((float)11.0f, (float)keys.get(0), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(0), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)12.0f, (float)keys.get(1), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(1), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)13.0f, (float)keys.get(2), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(2), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)14.0f, (float)keys.get(3), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(3), (float)1.0E-6f);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenFloatFloatHashMapTest.assertEquals((float)11.0f, (float)keys.get(3), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)100.0f, (float)values.get(3), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)12.0f, (float)keys.get(2), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)70.0f, (float)values.get(2), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)13.0f, (float)keys.get(1), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)30.0f, (float)values.get(1), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)14.0f, (float)keys.get(0), (float)1.0E-6f);
        OpenFloatFloatHashMapTest.assertEquals((float)3.0f, (float)values.get(0), (float)1.0E-6f);
    }

    private static class Pair
    implements Comparable<Pair> {
        float k;
        float v;

        Pair(float k, float v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

