/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.IntByteProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntByteHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenIntByteHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntByteHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenIntByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenIntByteHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenIntByteHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntByteHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenIntByteHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        OpenIntByteHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenIntByteHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenIntByteHashMapTest.assertEquals((double)0.0, (double)map.get(11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        OpenIntByteHashMap map2 = (OpenIntByteHashMap)map.clone();
        map.clear();
        OpenIntByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        OpenIntByteHashMapTest.assertTrue((boolean)map.containsKey(11));
        OpenIntByteHashMapTest.assertFalse((boolean)map.containsKey(12));
    }

    @Test
    public void testContainValue() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        OpenIntByteHashMapTest.assertTrue((boolean)map.containsValue((byte)22));
        OpenIntByteHashMapTest.assertFalse((boolean)map.containsValue((byte)23));
    }

    @Test
    public void testForEachKey() {
        final IntArrayList keys = new IntArrayList();
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        map.put(12, (byte)23);
        map.put(13, (byte)24);
        map.put(14, (byte)25);
        map.removeKey(13);
        map.forEachKey(new IntProcedure(){

            public boolean apply(int element) {
                keys.add(element);
                return true;
            }
        });
        int[] keysArray = keys.toArray(new int[keys.size()]);
        Arrays.sort(keysArray);
        OpenIntByteHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        map.put(12, (byte)23);
        map.put(13, (byte)24);
        map.put(14, (byte)25);
        map.removeKey(13);
        map.forEachPair(new IntByteProcedure(){

            public boolean apply(int first, byte second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenIntByteHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenIntByteHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenIntByteHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenIntByteHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenIntByteHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenIntByteHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenIntByteHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new IntByteProcedure(){
            int count = 0;

            public boolean apply(int first, byte second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenIntByteHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        map.put(12, (byte)23);
        OpenIntByteHashMapTest.assertEquals((long)22L, (long)map.get(11));
        OpenIntByteHashMapTest.assertEquals((long)0L, (long)map.get(0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        map.put(12, (byte)23);
        map.put(13, (byte)24);
        map.put(14, (byte)25);
        map.adjustOrPutValue(11, (byte)1, (byte)3);
        OpenIntByteHashMapTest.assertEquals((long)25L, (long)map.get(11));
        map.adjustOrPutValue(15, (byte)1, (byte)3);
        OpenIntByteHashMapTest.assertEquals((long)1L, (long)map.get(15));
    }

    @Test
    public void testKeys() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        map.put(12, (byte)22);
        IntArrayList keys = new IntArrayList();
        map.keys(keys);
        keys.sort();
        OpenIntByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        IntArrayList k2 = map.keys();
        k2.sort();
        OpenIntByteHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        IntArrayList keyList = new IntArrayList();
        ByteArrayList valueList = new ByteArrayList();
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        map.put(12, (byte)23);
        map.put(13, (byte)24);
        map.put(14, (byte)25);
        map.removeKey(13);
        map.pairsMatching(new IntByteProcedure(){

            public boolean apply(int first, byte second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenIntByteHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenIntByteHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenIntByteHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenIntByteHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenIntByteHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenIntByteHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        map.put(12, (byte)23);
        map.put(13, (byte)24);
        map.put(14, (byte)25);
        map.removeKey(13);
        ByteArrayList values = new ByteArrayList(100);
        map.values(values);
        OpenIntByteHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenIntByteHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenIntByteHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenIntByteHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        OpenIntByteHashMap map2 = (OpenIntByteHashMap)map.copy();
        map.clear();
        OpenIntByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        map.put(12, (byte)23);
        map.put(13, (byte)24);
        map.put(14, (byte)25);
        map.removeKey(13);
        OpenIntByteHashMap map2 = (OpenIntByteHashMap)map.copy();
        OpenIntByteHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenIntByteHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenIntByteHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenIntByteHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11);
        OpenIntByteHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenIntByteHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)22);
        map.put(12, (byte)23);
        map.put(13, (byte)24);
        map.put(14, (byte)25);
        map.removeKey(13);
        IntArrayList keys = new IntArrayList();
        map.keysSortedByValue(keys);
        int[] keysArray = keys.toArray(new int[keys.size()]);
        OpenIntByteHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenIntByteHashMap map = new OpenIntByteHashMap();
        map.put(11, (byte)100);
        map.put(12, (byte)70);
        map.put(13, (byte)30);
        map.put(14, (byte)3);
        IntArrayList keys = new IntArrayList();
        ByteArrayList values = new ByteArrayList();
        map.pairsSortedByKey(keys, values);
        OpenIntByteHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenIntByteHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenIntByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntByteHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenIntByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenIntByteHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenIntByteHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenIntByteHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenIntByteHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenIntByteHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenIntByteHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenIntByteHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenIntByteHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenIntByteHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenIntByteHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenIntByteHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenIntByteHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenIntByteHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        int k;
        byte v;

        Pair(int k, byte v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

