/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.IntLongProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenIntLongHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenIntLongHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntLongHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenIntLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenIntLongHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenIntLongHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntLongHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenIntLongHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        OpenIntLongHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenIntLongHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenIntLongHashMapTest.assertEquals((double)0.0, (double)map.get(11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        OpenIntLongHashMap map2 = (OpenIntLongHashMap)map.clone();
        map.clear();
        OpenIntLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        OpenIntLongHashMapTest.assertTrue((boolean)map.containsKey(11));
        OpenIntLongHashMapTest.assertFalse((boolean)map.containsKey(12));
    }

    @Test
    public void testContainValue() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        OpenIntLongHashMapTest.assertTrue((boolean)map.containsValue(22L));
        OpenIntLongHashMapTest.assertFalse((boolean)map.containsValue(23L));
    }

    @Test
    public void testForEachKey() {
        final IntArrayList keys = new IntArrayList();
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        map.put(12, 23L);
        map.put(13, 24L);
        map.put(14, 25L);
        map.removeKey(13);
        map.forEachKey(new IntProcedure(){

            public boolean apply(int element) {
                keys.add(element);
                return true;
            }
        });
        int[] keysArray = keys.toArray(new int[keys.size()]);
        Arrays.sort(keysArray);
        OpenIntLongHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        map.put(12, 23L);
        map.put(13, 24L);
        map.put(14, 25L);
        map.removeKey(13);
        map.forEachPair(new IntLongProcedure(){

            public boolean apply(int first, long second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenIntLongHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenIntLongHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenIntLongHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenIntLongHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenIntLongHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenIntLongHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenIntLongHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new IntLongProcedure(){
            int count = 0;

            public boolean apply(int first, long second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenIntLongHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        map.put(12, 23L);
        OpenIntLongHashMapTest.assertEquals((long)22L, (long)map.get(11));
        OpenIntLongHashMapTest.assertEquals((long)0L, (long)map.get(0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        map.put(12, 23L);
        map.put(13, 24L);
        map.put(14, 25L);
        map.adjustOrPutValue(11, 1L, 3L);
        OpenIntLongHashMapTest.assertEquals((long)25L, (long)map.get(11));
        map.adjustOrPutValue(15, 1L, 3L);
        OpenIntLongHashMapTest.assertEquals((long)1L, (long)map.get(15));
    }

    @Test
    public void testKeys() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        map.put(12, 22L);
        IntArrayList keys = new IntArrayList();
        map.keys(keys);
        keys.sort();
        OpenIntLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        IntArrayList k2 = map.keys();
        k2.sort();
        OpenIntLongHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        IntArrayList keyList = new IntArrayList();
        LongArrayList valueList = new LongArrayList();
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        map.put(12, 23L);
        map.put(13, 24L);
        map.put(14, 25L);
        map.removeKey(13);
        map.pairsMatching(new IntLongProcedure(){

            public boolean apply(int first, long second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenIntLongHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenIntLongHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenIntLongHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenIntLongHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenIntLongHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenIntLongHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        map.put(12, 23L);
        map.put(13, 24L);
        map.put(14, 25L);
        map.removeKey(13);
        LongArrayList values = new LongArrayList(100);
        map.values(values);
        OpenIntLongHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenIntLongHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenIntLongHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenIntLongHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        OpenIntLongHashMap map2 = (OpenIntLongHashMap)map.copy();
        map.clear();
        OpenIntLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        map.put(12, 23L);
        map.put(13, 24L);
        map.put(14, 25L);
        map.removeKey(13);
        OpenIntLongHashMap map2 = (OpenIntLongHashMap)map.copy();
        OpenIntLongHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenIntLongHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenIntLongHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenIntLongHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11);
        OpenIntLongHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenIntLongHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 22L);
        map.put(12, 23L);
        map.put(13, 24L);
        map.put(14, 25L);
        map.removeKey(13);
        IntArrayList keys = new IntArrayList();
        map.keysSortedByValue(keys);
        int[] keysArray = keys.toArray(new int[keys.size()]);
        OpenIntLongHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenIntLongHashMap map = new OpenIntLongHashMap();
        map.put(11, 100L);
        map.put(12, 70L);
        map.put(13, 30L);
        map.put(14, 3L);
        IntArrayList keys = new IntArrayList();
        LongArrayList values = new LongArrayList();
        map.pairsSortedByKey(keys, values);
        OpenIntLongHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenIntLongHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenIntLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntLongHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenIntLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenIntLongHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenIntLongHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenIntLongHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenIntLongHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenIntLongHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenIntLongHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenIntLongHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenIntLongHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenIntLongHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenIntLongHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenIntLongHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenIntLongHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenIntLongHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        int k;
        long v;

        Pair(int k, long v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

