/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ShortLongProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenShortLongHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenShortLongHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortLongHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenShortLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenShortLongHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenShortLongHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortLongHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenShortLongHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        OpenShortLongHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenShortLongHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenShortLongHashMapTest.assertEquals((double)0.0, (double)map.get((short)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        OpenShortLongHashMap map2 = (OpenShortLongHashMap)map.clone();
        map.clear();
        OpenShortLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        OpenShortLongHashMapTest.assertTrue((boolean)map.containsKey((short)11));
        OpenShortLongHashMapTest.assertFalse((boolean)map.containsKey((short)12));
    }

    @Test
    public void testContainValue() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        OpenShortLongHashMapTest.assertTrue((boolean)map.containsValue(22L));
        OpenShortLongHashMapTest.assertFalse((boolean)map.containsValue(23L));
    }

    @Test
    public void testForEachKey() {
        final ShortArrayList keys = new ShortArrayList();
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        map.put((short)12, 23L);
        map.put((short)13, 24L);
        map.put((short)14, 25L);
        map.removeKey((short)13);
        map.forEachKey(new ShortProcedure(){

            public boolean apply(short element) {
                keys.add(element);
                return true;
            }
        });
        short[] keysArray = keys.toArray(new short[keys.size()]);
        Arrays.sort(keysArray);
        OpenShortLongHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        map.put((short)12, 23L);
        map.put((short)13, 24L);
        map.put((short)14, 25L);
        map.removeKey((short)13);
        map.forEachPair(new ShortLongProcedure(){

            public boolean apply(short first, long second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenShortLongHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenShortLongHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenShortLongHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenShortLongHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenShortLongHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenShortLongHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenShortLongHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ShortLongProcedure(){
            int count = 0;

            public boolean apply(short first, long second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenShortLongHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        map.put((short)12, 23L);
        OpenShortLongHashMapTest.assertEquals((long)22L, (long)map.get((short)11));
        OpenShortLongHashMapTest.assertEquals((long)0L, (long)map.get((short)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        map.put((short)12, 23L);
        map.put((short)13, 24L);
        map.put((short)14, 25L);
        map.adjustOrPutValue((short)11, 1L, 3L);
        OpenShortLongHashMapTest.assertEquals((long)25L, (long)map.get((short)11));
        map.adjustOrPutValue((short)15, 1L, 3L);
        OpenShortLongHashMapTest.assertEquals((long)1L, (long)map.get((short)15));
    }

    @Test
    public void testKeys() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        map.put((short)12, 22L);
        ShortArrayList keys = new ShortArrayList();
        map.keys(keys);
        keys.sort();
        OpenShortLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ShortArrayList k2 = map.keys();
        k2.sort();
        OpenShortLongHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ShortArrayList keyList = new ShortArrayList();
        LongArrayList valueList = new LongArrayList();
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        map.put((short)12, 23L);
        map.put((short)13, 24L);
        map.put((short)14, 25L);
        map.removeKey((short)13);
        map.pairsMatching(new ShortLongProcedure(){

            public boolean apply(short first, long second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenShortLongHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenShortLongHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenShortLongHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenShortLongHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenShortLongHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenShortLongHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        map.put((short)12, 23L);
        map.put((short)13, 24L);
        map.put((short)14, 25L);
        map.removeKey((short)13);
        LongArrayList values = new LongArrayList(100);
        map.values(values);
        OpenShortLongHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenShortLongHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenShortLongHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenShortLongHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        OpenShortLongHashMap map2 = (OpenShortLongHashMap)map.copy();
        map.clear();
        OpenShortLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        map.put((short)12, 23L);
        map.put((short)13, 24L);
        map.put((short)14, 25L);
        map.removeKey((short)13);
        OpenShortLongHashMap map2 = (OpenShortLongHashMap)map.copy();
        OpenShortLongHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenShortLongHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenShortLongHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenShortLongHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((short)11);
        OpenShortLongHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenShortLongHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 22L);
        map.put((short)12, 23L);
        map.put((short)13, 24L);
        map.put((short)14, 25L);
        map.removeKey((short)13);
        ShortArrayList keys = new ShortArrayList();
        map.keysSortedByValue(keys);
        short[] keysArray = keys.toArray(new short[keys.size()]);
        OpenShortLongHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenShortLongHashMap map = new OpenShortLongHashMap();
        map.put((short)11, 100L);
        map.put((short)12, 70L);
        map.put((short)13, 30L);
        map.put((short)14, 3L);
        ShortArrayList keys = new ShortArrayList();
        LongArrayList values = new LongArrayList();
        map.pairsSortedByKey(keys, values);
        OpenShortLongHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenShortLongHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenShortLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortLongHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenShortLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenShortLongHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenShortLongHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenShortLongHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenShortLongHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenShortLongHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenShortLongHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenShortLongHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenShortLongHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenShortLongHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenShortLongHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenShortLongHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenShortLongHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenShortLongHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        short k;
        long v;

        Pair(short k, long v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

