/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.als.ParallelALSFactorizationJob;
import org.apache.mahout.cf.taste.hadoop.als.RecommenderJob;
import org.apache.mahout.cf.taste.hadoop.als.SharingMapper;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.MathHelper;
import org.apache.mahout.math.map.OpenIntLongHashMap;
import org.apache.mahout.math.map.OpenIntObjectHashMap;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelALSFactorizationJobTest
extends TasteTestCase {
    private static final Logger log = LoggerFactory.getLogger(ParallelALSFactorizationJobTest.class);
    private File inputFile;
    private File intermediateDir;
    private File outputDir;
    private File tmpDir;
    private Configuration conf;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.inputFile = this.getTestTempFile("prefs.txt");
        this.intermediateDir = this.getTestTempDir("intermediate");
        this.intermediateDir.delete();
        this.outputDir = this.getTestTempDir("output");
        this.outputDir.delete();
        this.tmpDir = this.getTestTempDir("tmp");
        this.conf = this.getConfiguration();
        SharingMapper.reset();
    }

    @Test
    public void completeJobToyExample() throws Exception {
        this.explicitExample(1);
    }

    @Test
    public void completeJobToyExampleMultithreaded() throws Exception {
        this.explicitExample(2);
    }

    private void explicitExample(int numThreads) throws Exception {
        Double na = Double.NaN;
        SparseRowMatrix preferences = new SparseRowMatrix(4, 4, new Vector[]{new DenseVector(new double[]{5.0, 5.0, 2.0, na}), new DenseVector(new double[]{2.0, na, 3.0, 5.0}), new DenseVector(new double[]{na, 5.0, na, 3.0}), new DenseVector(new double[]{3.0, na, na, 5.0})});
        ParallelALSFactorizationJobTest.writeLines(this.inputFile, ParallelALSFactorizationJobTest.preferencesAsText((Matrix)preferences));
        ParallelALSFactorizationJob alsFactorization = new ParallelALSFactorizationJob();
        alsFactorization.setConf(this.conf);
        int numFeatures = 3;
        int numIterations = 5;
        double lambda = 0.065;
        alsFactorization.run(new String[]{"--input", this.inputFile.getAbsolutePath(), "--output", this.outputDir.getAbsolutePath(), "--tempDir", this.tmpDir.getAbsolutePath(), "--lambda", String.valueOf(lambda), "--numFeatures", String.valueOf(numFeatures), "--numIterations", String.valueOf(numIterations), "--numThreadsPerSolver", String.valueOf(numThreads)});
        Matrix u = MathHelper.readMatrix(this.conf, new Path(this.outputDir.getAbsolutePath(), "U/part-m-00000"), preferences.numRows(), numFeatures);
        Matrix m = MathHelper.readMatrix(this.conf, new Path(this.outputDir.getAbsolutePath(), "M/part-m-00000"), preferences.numCols(), numFeatures);
        StringBuilder info = new StringBuilder();
        info.append("\nA - users x items\n\n");
        info.append(MathHelper.nice((Matrix)preferences));
        info.append("\nU - users x features\n\n");
        info.append(MathHelper.nice(u));
        info.append("\nM - items x features\n\n");
        info.append(MathHelper.nice(m));
        Matrix Ak = u.times(m.transpose());
        info.append("\nAk - users x items\n\n");
        info.append(MathHelper.nice(Ak));
        info.append('\n');
        log.info(info.toString());
        FullRunningAverage avg = new FullRunningAverage();
        for (MatrixSlice slice : preferences) {
            for (Vector.Element e : slice.nonZeroes()) {
                if (Double.isNaN(e.get())) continue;
                double pref = e.get();
                double estimate = u.viewRow(slice.index()).dot(m.viewRow(e.index()));
                double err = pref - estimate;
                avg.addDatum(err * err);
                log.info("Comparing preference of user [{}] towards item [{}], was [{}] estimate is [{}]", new Object[]{slice.index(), e.index(), pref, estimate});
            }
        }
        double rmse = Math.sqrt(avg.getAverage());
        log.info("RMSE: {}", (Object)rmse);
        ParallelALSFactorizationJobTest.assertTrue((rmse < 0.2 ? 1 : 0) != 0);
    }

    @Test
    public void completeJobImplicitToyExample() throws Exception {
        this.implicitExample(1);
    }

    @Test
    public void completeJobImplicitToyExampleMultithreaded() throws Exception {
        this.implicitExample(2);
    }

    public void implicitExample(int numThreads) throws Exception {
        SparseRowMatrix observations = new SparseRowMatrix(4, 4, new Vector[]{new DenseVector(new double[]{5.0, 5.0, 2.0, 0.0}), new DenseVector(new double[]{2.0, 0.0, 3.0, 5.0}), new DenseVector(new double[]{0.0, 5.0, 0.0, 3.0}), new DenseVector(new double[]{3.0, 0.0, 0.0, 5.0})});
        SparseRowMatrix preferences = new SparseRowMatrix(4, 4, new Vector[]{new DenseVector(new double[]{1.0, 1.0, 1.0, 0.0}), new DenseVector(new double[]{1.0, 0.0, 1.0, 1.0}), new DenseVector(new double[]{0.0, 1.0, 0.0, 1.0}), new DenseVector(new double[]{1.0, 0.0, 0.0, 1.0})});
        ParallelALSFactorizationJobTest.writeLines(this.inputFile, ParallelALSFactorizationJobTest.preferencesAsText((Matrix)observations));
        ParallelALSFactorizationJob alsFactorization = new ParallelALSFactorizationJob();
        alsFactorization.setConf(this.conf);
        int numFeatures = 3;
        int numIterations = 5;
        double lambda = 0.065;
        double alpha = 20.0;
        alsFactorization.run(new String[]{"--input", this.inputFile.getAbsolutePath(), "--output", this.outputDir.getAbsolutePath(), "--tempDir", this.tmpDir.getAbsolutePath(), "--lambda", String.valueOf(lambda), "--implicitFeedback", String.valueOf(true), "--alpha", String.valueOf(alpha), "--numFeatures", String.valueOf(numFeatures), "--numIterations", String.valueOf(numIterations), "--numThreadsPerSolver", String.valueOf(numThreads)});
        Matrix u = MathHelper.readMatrix(this.conf, new Path(this.outputDir.getAbsolutePath(), "U/part-m-00000"), observations.numRows(), numFeatures);
        Matrix m = MathHelper.readMatrix(this.conf, new Path(this.outputDir.getAbsolutePath(), "M/part-m-00000"), observations.numCols(), numFeatures);
        StringBuilder info = new StringBuilder();
        info.append("\nObservations - users x items\n");
        info.append(MathHelper.nice((Matrix)observations));
        info.append("\nA - users x items\n\n");
        info.append(MathHelper.nice((Matrix)preferences));
        info.append("\nU - users x features\n\n");
        info.append(MathHelper.nice(u));
        info.append("\nM - items x features\n\n");
        info.append(MathHelper.nice(m));
        Matrix Ak = u.times(m.transpose());
        info.append("\nAk - users x items\n\n");
        info.append(MathHelper.nice(Ak));
        info.append('\n');
        log.info(info.toString());
        FullRunningAverage avg = new FullRunningAverage();
        for (MatrixSlice slice : preferences) {
            for (Vector.Element e : slice.nonZeroes()) {
                if (Double.isNaN(e.get())) continue;
                double pref = e.get();
                double estimate = u.viewRow(slice.index()).dot(m.viewRow(e.index()));
                double confidence = 1.0 + alpha * observations.getQuick(slice.index(), e.index());
                double err = confidence * (pref - estimate) * (pref - estimate);
                avg.addDatum(err);
                log.info("Comparing preference of user [{}] towards item [{}], was [{}] with confidence [{}] estimate is [{}]", new Object[]{slice.index(), e.index(), pref, confidence, estimate});
            }
        }
        double rmse = Math.sqrt(avg.getAverage());
        log.info("RMSE: {}", (Object)rmse);
        ParallelALSFactorizationJobTest.assertTrue((rmse < 0.4 ? 1 : 0) != 0);
    }

    @Test
    public void exampleWithIDMapping() throws Exception {
        String[] preferencesWithLongIDs = new String[]{"5568227754922264005,-4758971626494767444,5.0", "5568227754922264005,3688396615879561990,5.0", "5568227754922264005,4594226737871995304,2.0", "550945997885173934,-4758971626494767444,2.0", "550945997885173934,4594226737871995304,3.0", "550945997885173934,706816485922781596,5.0", "2448095297482319463,3688396615879561990,5.0", "2448095297482319463,706816485922781596,3.0", "6839920411763636962,-4758971626494767444,3.0", "6839920411763636962,706816485922781596,5.0"};
        ParallelALSFactorizationJobTest.writeLines(this.inputFile, preferencesWithLongIDs);
        ParallelALSFactorizationJob alsFactorization = new ParallelALSFactorizationJob();
        alsFactorization.setConf(this.conf);
        int numFeatures = 3;
        int numIterations = 5;
        double lambda = 0.065;
        alsFactorization.run(new String[]{"--input", this.inputFile.getAbsolutePath(), "--output", this.outputDir.getAbsolutePath(), "--tempDir", this.tmpDir.getAbsolutePath(), "--lambda", String.valueOf(lambda), "--numFeatures", String.valueOf(numFeatures), "--numIterations", String.valueOf(numIterations), "--numThreadsPerSolver", String.valueOf(1), "--usesLongIDs", String.valueOf(true)});
        OpenIntLongHashMap userIDIndex = TasteHadoopUtils.readIDIndexMap((String)(this.outputDir.getAbsolutePath() + "/userIDIndex/part-r-00000"), (Configuration)this.conf);
        ParallelALSFactorizationJobTest.assertEquals((long)4L, (long)userIDIndex.size());
        OpenIntLongHashMap itemIDIndex = TasteHadoopUtils.readIDIndexMap((String)(this.outputDir.getAbsolutePath() + "/itemIDIndex/part-r-00000"), (Configuration)this.conf);
        ParallelALSFactorizationJobTest.assertEquals((long)4L, (long)itemIDIndex.size());
        OpenIntObjectHashMap<Vector> u = MathHelper.readMatrixRows(this.conf, new Path(this.outputDir.getAbsolutePath(), "U/part-m-00000"));
        OpenIntObjectHashMap<Vector> m = MathHelper.readMatrixRows(this.conf, new Path(this.outputDir.getAbsolutePath(), "M/part-m-00000"));
        ParallelALSFactorizationJobTest.assertEquals((long)4L, (long)u.size());
        ParallelALSFactorizationJobTest.assertEquals((long)4L, (long)m.size());
        FullRunningAverage avg = new FullRunningAverage();
        for (String line : preferencesWithLongIDs) {
            String[] tokens = TasteHadoopUtils.splitPrefTokens((CharSequence)line);
            long userID = Long.parseLong(tokens[0]);
            long itemID = Long.parseLong(tokens[1]);
            double rating = Double.parseDouble(tokens[2]);
            Vector userFeatures = (Vector)u.get(TasteHadoopUtils.idToIndex((long)userID));
            Vector itemFeatures = (Vector)m.get(TasteHadoopUtils.idToIndex((long)itemID));
            double estimate = userFeatures.dot(itemFeatures);
            double err = rating - estimate;
            avg.addDatum(err * err);
        }
        double rmse = Math.sqrt(avg.getAverage());
        log.info("RMSE: {}", (Object)rmse);
        ParallelALSFactorizationJobTest.assertTrue((rmse < 0.2 ? 1 : 0) != 0);
    }

    protected static String preferencesAsText(Matrix preferences) {
        StringBuilder prefsAsText = new StringBuilder();
        String separator = "";
        for (MatrixSlice slice : preferences) {
            for (Vector.Element e : slice.nonZeroes()) {
                if (Double.isNaN(e.get())) continue;
                prefsAsText.append(separator).append(slice.index()).append(',').append(e.index()).append(',').append(e.get());
                separator = "\n";
            }
        }
        System.out.println(prefsAsText.toString());
        return prefsAsText.toString();
    }

    @Test
    public void recommenderJobWithIDMapping() throws Exception {
        String[] preferencesWithLongIDs = new String[]{"5568227754922264005,-4758971626494767444,5.0", "5568227754922264005,3688396615879561990,5.0", "5568227754922264005,4594226737871995304,2.0", "550945997885173934,-4758971626494767444,2.0", "550945997885173934,4594226737871995304,3.0", "550945997885173934,706816485922781596,5.0", "2448095297482319463,3688396615879561990,5.0", "2448095297482319463,706816485922781596,3.0", "6839920411763636962,-4758971626494767444,3.0", "6839920411763636962,706816485922781596,5.0"};
        ParallelALSFactorizationJobTest.writeLines(this.inputFile, preferencesWithLongIDs);
        ParallelALSFactorizationJob alsFactorization = new ParallelALSFactorizationJob();
        alsFactorization.setConf(this.conf);
        int numFeatures = 3;
        int numIterations = 5;
        double lambda = 0.065;
        Configuration conf = this.getConfiguration();
        int success = ToolRunner.run((Tool)alsFactorization, (String[])new String[]{"-Dhadoop.tmp.dir=" + conf.get("hadoop.tmp.dir"), "--input", this.inputFile.getAbsolutePath(), "--output", this.intermediateDir.getAbsolutePath(), "--tempDir", this.tmpDir.getAbsolutePath(), "--lambda", String.valueOf(lambda), "--numFeatures", String.valueOf(numFeatures), "--numIterations", String.valueOf(numIterations), "--numThreadsPerSolver", String.valueOf(1), "--usesLongIDs", String.valueOf(true)});
        ParallelALSFactorizationJobTest.assertEquals((long)0L, (long)success);
        SharingMapper.reset();
        RecommenderJob recommender = new RecommenderJob();
        success = ToolRunner.run((Tool)recommender, (String[])new String[]{"-Dhadoop.tmp.dir=" + conf.get("hadoop.tmp.dir"), "--input", this.intermediateDir.getAbsolutePath() + "/userRatings/", "--userFeatures", this.intermediateDir.getAbsolutePath() + "/U/", "--itemFeatures", this.intermediateDir.getAbsolutePath() + "/M/", "--numRecommendations", String.valueOf(2), "--maxRating", String.valueOf(5.0), "--numThreads", String.valueOf(2), "--usesLongIDs", String.valueOf(true), "--userIDIndex", this.intermediateDir.getAbsolutePath() + "/userIDIndex/", "--itemIDIndex", this.intermediateDir.getAbsolutePath() + "/itemIDIndex/", "--output", this.outputDir.getAbsolutePath()});
        ParallelALSFactorizationJobTest.assertEquals((long)0L, (long)success);
    }
}

