/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.model.GenericBooleanPrefDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.common.MahoutTestCase;

public abstract class TasteTestCase
extends MahoutTestCase {
    public static DataModel getDataModel(long[] userIDs, Double[][] prefValues) {
        FastByIDMap result = new FastByIDMap();
        for (int i = 0; i < userIDs.length; ++i) {
            ArrayList prefsList = Lists.newArrayList();
            for (int j = 0; j < prefValues[i].length; ++j) {
                if (prefValues[i][j] == null) continue;
                prefsList.add(new GenericPreference(userIDs[i], (long)j, prefValues[i][j].floatValue()));
            }
            if (prefsList.isEmpty()) continue;
            result.put(userIDs[i], (Object)new GenericUserPreferenceArray((List)prefsList));
        }
        return new GenericDataModel(result);
    }

    public static DataModel getBooleanDataModel(long[] userIDs, boolean[][] prefs) {
        FastByIDMap result = new FastByIDMap();
        for (int i = 0; i < userIDs.length; ++i) {
            FastIDSet prefsSet = new FastIDSet();
            for (int j = 0; j < prefs[i].length; ++j) {
                if (!prefs[i][j]) continue;
                prefsSet.add((long)j);
            }
            if (prefsSet.isEmpty()) continue;
            result.put(userIDs[i], (Object)prefsSet);
        }
        return new GenericBooleanPrefDataModel(result);
    }

    protected static DataModel getDataModel() {
        return TasteTestCase.getDataModel(new long[]{1L, 2L, 3L, 4L}, new Double[][]{{0.1, 0.3}, {0.2, 0.3, 0.3}, {0.4, 0.3, 0.5}, {0.7, 0.3, 0.8}});
    }

    protected static DataModel getBooleanDataModel() {
        return TasteTestCase.getBooleanDataModel(new long[]{1L, 2L, 3L, 4L}, new boolean[][]{{false, true, false}, {false, true, true, false}, {true, false, false, true}, {true, false, true, true}});
    }

    protected static boolean arrayContains(long[] array, long value) {
        for (long l : array) {
            if (l != value) continue;
            return true;
        }
        return false;
    }
}

