/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.Cache;
import org.apache.mahout.cf.taste.impl.common.Retriever;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Test;

public final class CacheTest
extends TasteTestCase {
    @Test
    public void testLotsOfGets() throws TasteException {
        IdentityRetriever retriever = new IdentityRetriever();
        Cache cache = new Cache((Retriever)retriever, 1000);
        for (int i = 0; i < 1000000; ++i) {
            CacheTest.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
    }

    @Test
    public void testMixedUsage() throws TasteException {
        RandomWrapper random = RandomUtils.getRandom();
        IdentityRetriever retriever = new IdentityRetriever();
        Cache cache = new Cache((Retriever)retriever, 1000);
        for (int i = 0; i < 1000000; ++i) {
            double r = random.nextDouble();
            if (r < 0.01) {
                cache.clear();
                continue;
            }
            if (r < 0.1) {
                cache.remove((Object)(r - 100.0));
                continue;
            }
            CacheTest.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
    }

    private static class IdentityRetriever
    implements Retriever<Object, Object> {
        private IdentityRetriever() {
        }

        public Object get(Object key) throws TasteException {
            return key;
        }
    }
}

