/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.WeightedRunningAverage;
import org.apache.mahout.cf.taste.impl.common.WeightedRunningAverageAndStdDev;
import org.junit.Test;

public final class WeightedRunningAverageTest
extends TasteTestCase {
    @Test
    public void testWeighted() {
        WeightedRunningAverage runningAverage = new WeightedRunningAverage();
        WeightedRunningAverageTest.assertEquals((long)0L, (long)runningAverage.getCount());
        WeightedRunningAverageTest.assertTrue((boolean)Double.isNaN(runningAverage.getAverage()));
        runningAverage.addDatum(1.0, 2.0);
        WeightedRunningAverageTest.assertEquals((double)1.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        runningAverage.addDatum(1.0);
        WeightedRunningAverageTest.assertEquals((double)1.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        runningAverage.addDatum(8.0, 0.5);
        WeightedRunningAverageTest.assertEquals((double)2.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        runningAverage.addDatum(-4.0);
        WeightedRunningAverageTest.assertEquals((double)0.6666666666666666, (double)runningAverage.getAverage(), (double)1.0E-6);
        runningAverage.removeDatum(-4.0);
        WeightedRunningAverageTest.assertEquals((double)2.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        runningAverage.removeDatum(2.0, 2.0);
        WeightedRunningAverageTest.assertEquals((double)2.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        runningAverage.changeDatum(0.0);
        WeightedRunningAverageTest.assertEquals((double)2.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        runningAverage.changeDatum(4.0, 0.5);
        WeightedRunningAverageTest.assertEquals((double)3.3333333333333335, (double)runningAverage.getAverage(), (double)1.0E-6);
    }

    @Test
    public void testWeightedAndStdDev() {
        WeightedRunningAverageAndStdDev runningAverage = new WeightedRunningAverageAndStdDev();
        WeightedRunningAverageTest.assertEquals((long)0L, (long)runningAverage.getCount());
        WeightedRunningAverageTest.assertTrue((boolean)Double.isNaN(runningAverage.getAverage()));
        WeightedRunningAverageTest.assertTrue((boolean)Double.isNaN(runningAverage.getStandardDeviation()));
        runningAverage.addDatum(1.0);
        WeightedRunningAverageTest.assertEquals((double)1.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        WeightedRunningAverageTest.assertTrue((boolean)Double.isNaN(runningAverage.getStandardDeviation()));
        runningAverage.addDatum(1.0, 2.0);
        WeightedRunningAverageTest.assertEquals((double)1.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        WeightedRunningAverageTest.assertEquals((double)0.0, (double)runningAverage.getStandardDeviation(), (double)1.0E-6);
        runningAverage.addDatum(8.0, 0.5);
        WeightedRunningAverageTest.assertEquals((double)2.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        WeightedRunningAverageTest.assertEquals((double)Math.sqrt(10.5), (double)runningAverage.getStandardDeviation(), (double)1.0E-6);
        runningAverage.addDatum(-4.0);
        WeightedRunningAverageTest.assertEquals((double)0.6666666666666666, (double)runningAverage.getAverage(), (double)1.0E-6);
        WeightedRunningAverageTest.assertEquals((double)Math.sqrt(15.75), (double)runningAverage.getStandardDeviation(), (double)1.0E-6);
        runningAverage.removeDatum(-4.0);
        WeightedRunningAverageTest.assertEquals((double)2.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        WeightedRunningAverageTest.assertEquals((double)Math.sqrt(10.5), (double)runningAverage.getStandardDeviation(), (double)1.0E-6);
        runningAverage.removeDatum(2.0, 2.0);
        WeightedRunningAverageTest.assertEquals((double)2.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        WeightedRunningAverageTest.assertEquals((double)Math.sqrt(31.5), (double)runningAverage.getStandardDeviation(), (double)1.0E-6);
    }
}

