/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.model.BooleanItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.BooleanPreference;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.model.Preference;
import org.junit.Test;

public final class BooleanItemPreferenceArrayTest
extends TasteTestCase {
    @Test
    public void testUserID() {
        BooleanItemPreferenceArray prefs = new BooleanItemPreferenceArray(3);
        BooleanItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setItemID(0, 1L);
        BooleanItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(0));
        BooleanItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(1));
        BooleanItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(2));
    }

    @Test
    public void testItemID() {
        BooleanItemPreferenceArray prefs = new BooleanItemPreferenceArray(3);
        BooleanItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setUserID(0, 1L);
        prefs.setUserID(1, 2L);
        prefs.setUserID(2, 3L);
        BooleanItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(0));
        BooleanItemPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getUserID(1));
        BooleanItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getUserID(2));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetValue() {
        BooleanItemPreferenceArray prefs = new BooleanItemPreferenceArray(3);
        BooleanItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        BooleanItemPreferenceArrayTest.assertEquals((double)1.0, (double)prefs.getValue(2), (double)1.0E-6);
        prefs.setValue(0, 1.0f);
    }

    @Test
    public void testHasPref() {
        BooleanItemPreferenceArray prefs = new BooleanItemPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(1L, 3L, 5.0f));
        BooleanItemPreferenceArrayTest.assertTrue((boolean)prefs.hasPrefWithItemID(3L));
        BooleanItemPreferenceArrayTest.assertTrue((boolean)prefs.hasPrefWithUserID(1L));
        BooleanItemPreferenceArrayTest.assertFalse((boolean)prefs.hasPrefWithItemID(2L));
        BooleanItemPreferenceArrayTest.assertFalse((boolean)prefs.hasPrefWithUserID(2L));
    }

    @Test
    public void testSort() {
        BooleanItemPreferenceArray prefs = new BooleanItemPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(3L, 1L, 5.0f));
        prefs.set(1, (Preference)new GenericPreference(1L, 1L, 5.0f));
        prefs.set(2, (Preference)new GenericPreference(2L, 1L, 5.0f));
        prefs.sortByUser();
        BooleanItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(0));
        BooleanItemPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getUserID(1));
        BooleanItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getUserID(2));
    }

    @Test
    public void testClone() {
        BooleanItemPreferenceArray prefs = new BooleanItemPreferenceArray(3);
        prefs.set(0, (Preference)new BooleanPreference(3L, 1L));
        prefs.set(1, (Preference)new BooleanPreference(1L, 1L));
        prefs.set(2, (Preference)new BooleanPreference(2L, 1L));
        prefs = prefs.clone();
        BooleanItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getUserID(0));
        BooleanItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(1));
    }
}

