/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.recommender.ReversingRescorer;
import org.apache.mahout.cf.taste.impl.similarity.GenericItemSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.CandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.ItemBasedRecommender;
import org.apache.mahout.cf.taste.recommender.MostSimilarItemsCandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.easymock.EasyMock;
import org.junit.Test;

public final class GenericItemBasedRecommenderTest
extends TasteTestCase {
    @Test
    public void testRecommender() throws Exception {
        ItemBasedRecommender recommender = GenericItemBasedRecommenderTest.buildRecommender();
        List recommended = recommender.recommend(1L, 1);
        GenericItemBasedRecommenderTest.assertNotNull((Object)recommended);
        GenericItemBasedRecommenderTest.assertEquals((long)1L, (long)recommended.size());
        RecommendedItem firstRecommended = (RecommendedItem)recommended.get(0);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)firstRecommended.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.1f, (double)firstRecommended.getValue(), (double)1.0E-6);
        recommender.refresh(null);
        recommended = recommender.recommend(1L, 1);
        firstRecommended = (RecommendedItem)recommended.get(0);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)firstRecommended.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.1f, (double)firstRecommended.getValue(), (double)1.0E-6);
    }

    @Test
    public void testHowMany() throws Exception {
        int i;
        DataModel dataModel = GenericItemBasedRecommenderTest.getDataModel(new long[]{1L, 2L, 3L, 4L, 5L}, new Double[][]{{0.1, 0.2}, {0.2, 0.3, 0.3, 0.6}, {0.4, 0.4, 0.5, 0.9}, {0.1, 0.4, 0.5, 0.8, 0.9, 1.0}, {0.2, 0.3, 0.6, 0.7, 0.1, 0.2}});
        ArrayList similarities = Lists.newArrayList();
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int j = i2 + 1; j < 6; ++j) {
                similarities.add(new GenericItemSimilarity.ItemItemSimilarity((long)i2, (long)j, 1.0 / (1.0 + (double)i2 + (double)j)));
            }
        }
        GenericItemSimilarity similarity = new GenericItemSimilarity((Iterable)similarities);
        GenericItemBasedRecommender recommender = new GenericItemBasedRecommender(dataModel, (ItemSimilarity)similarity);
        List fewRecommended = recommender.recommend(1L, 2);
        List moreRecommended = recommender.recommend(1L, 4);
        for (i = 0; i < fewRecommended.size(); ++i) {
            GenericItemBasedRecommenderTest.assertEquals((long)((RecommendedItem)fewRecommended.get(i)).getItemID(), (long)((RecommendedItem)moreRecommended.get(i)).getItemID());
        }
        recommender.refresh(null);
        for (i = 0; i < fewRecommended.size(); ++i) {
            GenericItemBasedRecommenderTest.assertEquals((long)((RecommendedItem)fewRecommended.get(i)).getItemID(), (long)((RecommendedItem)moreRecommended.get(i)).getItemID());
        }
    }

    @Test
    public void testRescorer() throws Exception {
        DataModel dataModel = GenericItemBasedRecommenderTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{0.1, 0.2}, {0.2, 0.3, 0.3, 0.6}, {0.4, 0.4, 0.5, 0.9}});
        ArrayList similarities = Lists.newArrayList();
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 1L, 1.0));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 2L, 0.5));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 3L, 0.2));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 2L, 0.7));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 3L, 0.5));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(2L, 3L, 0.9));
        GenericItemSimilarity similarity = new GenericItemSimilarity((Iterable)similarities);
        GenericItemBasedRecommender recommender = new GenericItemBasedRecommender(dataModel, (ItemSimilarity)similarity);
        List originalRecommended = recommender.recommend(1L, 2);
        List rescoredRecommended = recommender.recommend(1L, 2, new ReversingRescorer());
        GenericItemBasedRecommenderTest.assertNotNull((Object)originalRecommended);
        GenericItemBasedRecommenderTest.assertNotNull((Object)rescoredRecommended);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)originalRecommended.size());
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)rescoredRecommended.size());
        GenericItemBasedRecommenderTest.assertEquals((long)((RecommendedItem)originalRecommended.get(0)).getItemID(), (long)((RecommendedItem)rescoredRecommended.get(1)).getItemID());
        GenericItemBasedRecommenderTest.assertEquals((long)((RecommendedItem)originalRecommended.get(1)).getItemID(), (long)((RecommendedItem)rescoredRecommended.get(0)).getItemID());
    }

    @Test
    public void testIncludeKnownItems() throws Exception {
        DataModel dataModel = GenericItemBasedRecommenderTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{0.1, 0.2}, {0.2, 0.3, 0.3, 0.6}, {0.4, 0.4, 0.5, 0.9}});
        ArrayList similarities = Lists.newArrayList();
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 1L, 0.8));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 2L, 0.5));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 3L, 0.2));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 2L, 0.7));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 3L, 0.5));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(2L, 3L, 0.9));
        GenericItemSimilarity similarity = new GenericItemSimilarity((Iterable)similarities);
        GenericItemBasedRecommender recommender = new GenericItemBasedRecommender(dataModel, (ItemSimilarity)similarity);
        List originalRecommended = recommender.recommend(1L, 4, null, true);
        List rescoredRecommended = recommender.recommend(1L, 4, new ReversingRescorer(), true);
        GenericItemBasedRecommenderTest.assertNotNull((Object)originalRecommended);
        GenericItemBasedRecommenderTest.assertNotNull((Object)rescoredRecommended);
        GenericItemBasedRecommenderTest.assertEquals((long)4L, (long)originalRecommended.size());
        GenericItemBasedRecommenderTest.assertEquals((long)4L, (long)rescoredRecommended.size());
        GenericItemBasedRecommenderTest.assertEquals((long)((RecommendedItem)originalRecommended.get(0)).getItemID(), (long)((RecommendedItem)rescoredRecommended.get(3)).getItemID());
        GenericItemBasedRecommenderTest.assertEquals((long)((RecommendedItem)originalRecommended.get(3)).getItemID(), (long)((RecommendedItem)rescoredRecommended.get(0)).getItemID());
    }

    @Test
    public void testEstimatePref() throws Exception {
        ItemBasedRecommender recommender = GenericItemBasedRecommenderTest.buildRecommender();
        GenericItemBasedRecommenderTest.assertEquals((double)0.1f, (double)recommender.estimatePreference(1L, 2L), (double)1.0E-6);
    }

    @Test
    public void testBestRating() throws Exception {
        ItemBasedRecommender recommender = GenericItemBasedRecommenderTest.buildRecommender();
        List recommended = recommender.recommend(1L, 1);
        GenericItemBasedRecommenderTest.assertNotNull((Object)recommended);
        GenericItemBasedRecommenderTest.assertEquals((long)1L, (long)recommended.size());
        RecommendedItem firstRecommended = (RecommendedItem)recommended.get(0);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)firstRecommended.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.1f, (double)firstRecommended.getValue(), (double)1.0E-6);
    }

    @Test
    public void testMostSimilar() throws Exception {
        ItemBasedRecommender recommender = GenericItemBasedRecommenderTest.buildRecommender();
        List similar = recommender.mostSimilarItems(0L, 2);
        GenericItemBasedRecommenderTest.assertNotNull((Object)similar);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)similar.size());
        RecommendedItem first = (RecommendedItem)similar.get(0);
        RecommendedItem second = (RecommendedItem)similar.get(1);
        GenericItemBasedRecommenderTest.assertEquals((long)1L, (long)first.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)1.0, (double)first.getValue(), (double)1.0E-6);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)second.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.5, (double)second.getValue(), (double)1.0E-6);
    }

    @Test
    public void testMostSimilarToMultiple() throws Exception {
        ItemBasedRecommender recommender = GenericItemBasedRecommenderTest.buildRecommender2();
        List similar = recommender.mostSimilarItems(new long[]{0L, 1L}, 2);
        GenericItemBasedRecommenderTest.assertNotNull((Object)similar);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)similar.size());
        RecommendedItem first = (RecommendedItem)similar.get(0);
        RecommendedItem second = (RecommendedItem)similar.get(1);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)first.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.85f, (double)first.getValue(), (double)1.0E-6);
        GenericItemBasedRecommenderTest.assertEquals((long)3L, (long)second.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)-0.3f, (double)second.getValue(), (double)1.0E-6);
    }

    @Test
    public void testMostSimilarToMultipleExcludeIfNotSimilarToAll() throws Exception {
        ItemBasedRecommender recommender = GenericItemBasedRecommenderTest.buildRecommender2();
        List similar = recommender.mostSimilarItems(new long[]{3L, 4L}, 2);
        GenericItemBasedRecommenderTest.assertNotNull((Object)similar);
        GenericItemBasedRecommenderTest.assertEquals((long)1L, (long)similar.size());
        RecommendedItem first = (RecommendedItem)similar.get(0);
        GenericItemBasedRecommenderTest.assertEquals((long)0L, (long)first.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.2f, (double)first.getValue(), (double)1.0E-6);
    }

    @Test
    public void testMostSimilarToMultipleDontExcludeIfNotSimilarToAll() throws Exception {
        ItemBasedRecommender recommender = GenericItemBasedRecommenderTest.buildRecommender2();
        List similar = recommender.mostSimilarItems(new long[]{1L, 2L, 4L}, 10, false);
        GenericItemBasedRecommenderTest.assertNotNull((Object)similar);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)similar.size());
        RecommendedItem first = (RecommendedItem)similar.get(0);
        RecommendedItem second = (RecommendedItem)similar.get(1);
        GenericItemBasedRecommenderTest.assertEquals((long)0L, (long)first.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.9333333373069763, (double)first.getValue(), (double)1.0E-6);
        GenericItemBasedRecommenderTest.assertEquals((long)3L, (long)second.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)-0.2f, (double)second.getValue(), (double)1.0E-6);
    }

    @Test
    public void testRecommendedBecause() throws Exception {
        ItemBasedRecommender recommender = GenericItemBasedRecommenderTest.buildRecommender2();
        List recommendedBecause = recommender.recommendedBecause(1L, 4L, 3);
        GenericItemBasedRecommenderTest.assertNotNull((Object)recommendedBecause);
        GenericItemBasedRecommenderTest.assertEquals((long)3L, (long)recommendedBecause.size());
        RecommendedItem first = (RecommendedItem)recommendedBecause.get(0);
        RecommendedItem second = (RecommendedItem)recommendedBecause.get(1);
        RecommendedItem third = (RecommendedItem)recommendedBecause.get(2);
        GenericItemBasedRecommenderTest.assertEquals((long)2L, (long)first.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.99f, (double)first.getValue(), (double)1.0E-6);
        GenericItemBasedRecommenderTest.assertEquals((long)3L, (long)second.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.4f, (double)second.getValue(), (double)1.0E-6);
        GenericItemBasedRecommenderTest.assertEquals((long)0L, (long)third.getItemID());
        GenericItemBasedRecommenderTest.assertEquals((double)0.2f, (double)third.getValue(), (double)1.0E-6);
    }

    private static ItemBasedRecommender buildRecommender() {
        DataModel dataModel = GenericItemBasedRecommenderTest.getDataModel();
        ArrayList similarities = Lists.newArrayList();
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 1L, 1.0));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 2L, 0.5));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 2L, 0.0));
        GenericItemSimilarity similarity = new GenericItemSimilarity((Iterable)similarities);
        return new GenericItemBasedRecommender(dataModel, (ItemSimilarity)similarity);
    }

    private static ItemBasedRecommender buildRecommender2() {
        DataModel dataModel = GenericItemBasedRecommenderTest.getDataModel(new long[]{1L, 2L, 3L, 4L}, new Double[][]{{0.1, 0.3, 0.9, 0.8}, {0.2, 0.3, 0.3, 0.4}, {0.4, 0.3, 0.5, 0.1, 0.1}, {0.7, 0.3, 0.8, 0.5, 0.6}});
        ArrayList similarities = Lists.newArrayList();
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 1L, 1.0));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 2L, 0.8));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 3L, -0.6));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(0L, 4L, 1.0));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 2L, 0.9));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 3L, 0.0));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 1L, 1.0));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(2L, 3L, -0.1));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(2L, 4L, 0.1));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(3L, 4L, -0.5));
        GenericItemSimilarity similarity = new GenericItemSimilarity((Iterable)similarities);
        return new GenericItemBasedRecommender(dataModel, (ItemSimilarity)similarity);
    }

    @Test
    public void preferencesFetchedOnlyOnce() throws Exception {
        DataModel dataModel = (DataModel)EasyMock.createMock(DataModel.class);
        ItemSimilarity itemSimilarity = (ItemSimilarity)EasyMock.createMock(ItemSimilarity.class);
        CandidateItemsStrategy candidateItemsStrategy = (CandidateItemsStrategy)EasyMock.createMock(CandidateItemsStrategy.class);
        MostSimilarItemsCandidateItemsStrategy mostSimilarItemsCandidateItemsStrategy = (MostSimilarItemsCandidateItemsStrategy)EasyMock.createMock(MostSimilarItemsCandidateItemsStrategy.class);
        GenericUserPreferenceArray preferencesFromUser = new GenericUserPreferenceArray(Arrays.asList(new GenericPreference(1L, 1L, 5.0f), new GenericPreference(1L, 2L, 4.0f)));
        EasyMock.expect((Object)Float.valueOf(dataModel.getMinPreference())).andReturn((Object)Float.valueOf(Float.NaN));
        EasyMock.expect((Object)Float.valueOf(dataModel.getMaxPreference())).andReturn((Object)Float.valueOf(Float.NaN));
        EasyMock.expect((Object)dataModel.getPreferencesFromUser(1L)).andReturn((Object)preferencesFromUser);
        EasyMock.expect((Object)candidateItemsStrategy.getCandidateItems(1L, (PreferenceArray)preferencesFromUser, dataModel, false)).andReturn((Object)new FastIDSet(new long[]{3L, 4L}));
        EasyMock.expect((Object)itemSimilarity.itemSimilarities(3L, preferencesFromUser.getIDs())).andReturn((Object)new double[]{0.5, 0.3});
        EasyMock.expect((Object)itemSimilarity.itemSimilarities(4L, preferencesFromUser.getIDs())).andReturn((Object)new double[]{0.4, 0.1});
        EasyMock.replay((Object[])new Object[]{dataModel, itemSimilarity, candidateItemsStrategy, mostSimilarItemsCandidateItemsStrategy});
        GenericItemBasedRecommender recommender = new GenericItemBasedRecommender(dataModel, itemSimilarity, candidateItemsStrategy, mostSimilarItemsCandidateItemsStrategy);
        recommender.recommend(1L, 3);
        EasyMock.verify((Object[])new Object[]{dataModel, itemSimilarity, candidateItemsStrategy, mostSimilarItemsCandidateItemsStrategy});
    }
}

