/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.neighborhood.NearestNUserNeighborhood;
import org.apache.mahout.cf.taste.impl.recommender.GenericUserBasedRecommender;
import org.apache.mahout.cf.taste.impl.recommender.ReversingRescorer;
import org.apache.mahout.cf.taste.impl.similarity.PearsonCorrelationSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.UserBasedRecommender;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;
import org.junit.Test;

public final class GenericUserBasedRecommenderTest
extends TasteTestCase {
    @Test
    public void testRecommender() throws Exception {
        UserBasedRecommender recommender = GenericUserBasedRecommenderTest.buildRecommender();
        List recommended = recommender.recommend(1L, 1);
        GenericUserBasedRecommenderTest.assertNotNull((Object)recommended);
        GenericUserBasedRecommenderTest.assertEquals((long)1L, (long)recommended.size());
        RecommendedItem firstRecommended = (RecommendedItem)recommended.get(0);
        GenericUserBasedRecommenderTest.assertEquals((long)2L, (long)firstRecommended.getItemID());
        GenericUserBasedRecommenderTest.assertEquals((double)0.1f, (double)firstRecommended.getValue(), (double)1.0E-6);
        recommender.refresh(null);
        GenericUserBasedRecommenderTest.assertEquals((long)2L, (long)firstRecommended.getItemID());
        GenericUserBasedRecommenderTest.assertEquals((double)0.1f, (double)firstRecommended.getValue(), (double)1.0E-6);
    }

    @Test
    public void testHowMany() throws Exception {
        int i;
        DataModel dataModel = GenericUserBasedRecommenderTest.getDataModel(new long[]{1L, 2L, 3L, 4L, 5L}, new Double[][]{{0.1, 0.2}, {0.2, 0.3, 0.3, 0.6}, {0.4, 0.4, 0.5, 0.9}, {0.1, 0.4, 0.5, 0.8, 0.9, 1.0}, {0.2, 0.3, 0.6, 0.7, 0.1, 0.2}});
        PearsonCorrelationSimilarity similarity = new PearsonCorrelationSimilarity(dataModel);
        NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(2, (UserSimilarity)similarity, dataModel);
        GenericUserBasedRecommender recommender = new GenericUserBasedRecommender(dataModel, (UserNeighborhood)neighborhood, (UserSimilarity)similarity);
        List fewRecommended = recommender.recommend(1L, 2);
        List moreRecommended = recommender.recommend(1L, 4);
        for (i = 0; i < fewRecommended.size(); ++i) {
            GenericUserBasedRecommenderTest.assertEquals((long)((RecommendedItem)fewRecommended.get(i)).getItemID(), (long)((RecommendedItem)moreRecommended.get(i)).getItemID());
        }
        recommender.refresh(null);
        for (i = 0; i < fewRecommended.size(); ++i) {
            GenericUserBasedRecommenderTest.assertEquals((long)((RecommendedItem)fewRecommended.get(i)).getItemID(), (long)((RecommendedItem)moreRecommended.get(i)).getItemID());
        }
    }

    @Test
    public void testRescorer() throws Exception {
        DataModel dataModel = GenericUserBasedRecommenderTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{0.1, 0.2}, {0.2, 0.3, 0.3, 0.6}, {0.4, 0.5, 0.5, 0.9}});
        PearsonCorrelationSimilarity similarity = new PearsonCorrelationSimilarity(dataModel);
        NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(2, (UserSimilarity)similarity, dataModel);
        GenericUserBasedRecommender recommender = new GenericUserBasedRecommender(dataModel, (UserNeighborhood)neighborhood, (UserSimilarity)similarity);
        List originalRecommended = recommender.recommend(1L, 2);
        List rescoredRecommended = recommender.recommend(1L, 2, new ReversingRescorer());
        GenericUserBasedRecommenderTest.assertNotNull((Object)originalRecommended);
        GenericUserBasedRecommenderTest.assertNotNull((Object)rescoredRecommended);
        GenericUserBasedRecommenderTest.assertEquals((long)2L, (long)originalRecommended.size());
        GenericUserBasedRecommenderTest.assertEquals((long)2L, (long)rescoredRecommended.size());
        GenericUserBasedRecommenderTest.assertEquals((long)((RecommendedItem)originalRecommended.get(0)).getItemID(), (long)((RecommendedItem)rescoredRecommended.get(1)).getItemID());
        GenericUserBasedRecommenderTest.assertEquals((long)((RecommendedItem)originalRecommended.get(1)).getItemID(), (long)((RecommendedItem)rescoredRecommended.get(0)).getItemID());
    }

    @Test
    public void testIncludeKnownItems() throws Exception {
        DataModel dataModel = GenericUserBasedRecommenderTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{0.1, 0.2}, {0.2, 0.3, 0.3, 0.6}, {0.4, 0.5, 0.5, 0.9}});
        PearsonCorrelationSimilarity similarity = new PearsonCorrelationSimilarity(dataModel);
        NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(2, (UserSimilarity)similarity, dataModel);
        GenericUserBasedRecommender recommender = new GenericUserBasedRecommender(dataModel, (UserNeighborhood)neighborhood, (UserSimilarity)similarity);
        List originalRecommended = recommender.recommend(1L, 4, null, true);
        List rescoredRecommended = recommender.recommend(1L, 4, new ReversingRescorer(), true);
        GenericUserBasedRecommenderTest.assertNotNull((Object)originalRecommended);
        GenericUserBasedRecommenderTest.assertNotNull((Object)rescoredRecommended);
        GenericUserBasedRecommenderTest.assertEquals((long)4L, (long)originalRecommended.size());
        GenericUserBasedRecommenderTest.assertEquals((long)4L, (long)rescoredRecommended.size());
        GenericUserBasedRecommenderTest.assertEquals((long)((RecommendedItem)originalRecommended.get(0)).getItemID(), (long)((RecommendedItem)rescoredRecommended.get(3)).getItemID());
        GenericUserBasedRecommenderTest.assertEquals((long)((RecommendedItem)originalRecommended.get(3)).getItemID(), (long)((RecommendedItem)rescoredRecommended.get(0)).getItemID());
    }

    @Test
    public void testEstimatePref() throws Exception {
        UserBasedRecommender recommender = GenericUserBasedRecommenderTest.buildRecommender();
        GenericUserBasedRecommenderTest.assertEquals((double)0.1f, (double)recommender.estimatePreference(1L, 2L), (double)1.0E-6);
    }

    @Test
    public void testBestRating() throws Exception {
        UserBasedRecommender recommender = GenericUserBasedRecommenderTest.buildRecommender();
        List recommended = recommender.recommend(1L, 1);
        GenericUserBasedRecommenderTest.assertNotNull((Object)recommended);
        GenericUserBasedRecommenderTest.assertEquals((long)1L, (long)recommended.size());
        RecommendedItem firstRecommended = (RecommendedItem)recommended.get(0);
        GenericUserBasedRecommenderTest.assertEquals((long)2L, (long)firstRecommended.getItemID());
        GenericUserBasedRecommenderTest.assertEquals((double)0.1f, (double)firstRecommended.getValue(), (double)1.0E-6);
    }

    @Test
    public void testMostSimilar() throws Exception {
        UserBasedRecommender recommender = GenericUserBasedRecommenderTest.buildRecommender();
        long[] similar = recommender.mostSimilarUserIDs(1L, 2);
        GenericUserBasedRecommenderTest.assertNotNull((Object)similar);
        GenericUserBasedRecommenderTest.assertEquals((long)2L, (long)similar.length);
        GenericUserBasedRecommenderTest.assertEquals((long)2L, (long)similar[0]);
        GenericUserBasedRecommenderTest.assertEquals((long)3L, (long)similar[1]);
    }

    @Test
    public void testIsolatedUser() throws Exception {
        DataModel dataModel = GenericUserBasedRecommenderTest.getDataModel(new long[]{1L, 2L, 3L, 4L}, new Double[][]{{0.1, 0.2}, {0.2, 0.3, 0.3, 0.6}, {0.4, 0.4, 0.5, 0.9}, {null, null, null, null, 1.0}});
        PearsonCorrelationSimilarity similarity = new PearsonCorrelationSimilarity(dataModel);
        NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(3, (UserSimilarity)similarity, dataModel);
        GenericUserBasedRecommender recommender = new GenericUserBasedRecommender(dataModel, (UserNeighborhood)neighborhood, (UserSimilarity)similarity);
        long[] mostSimilar = recommender.mostSimilarUserIDs(4L, 3);
        GenericUserBasedRecommenderTest.assertNotNull((Object)mostSimilar);
        GenericUserBasedRecommenderTest.assertEquals((long)0L, (long)mostSimilar.length);
    }

    private static UserBasedRecommender buildRecommender() throws TasteException {
        DataModel dataModel = GenericUserBasedRecommenderTest.getDataModel();
        PearsonCorrelationSimilarity similarity = new PearsonCorrelationSimilarity(dataModel);
        NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(2, (UserSimilarity)similarity, dataModel);
        return new GenericUserBasedRecommender(dataModel, (UserNeighborhood)neighborhood, (UserSimilarity)similarity);
    }
}

