/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;

final class MockRecommender
implements Recommender {
    private final MutableInt recommendCount;

    MockRecommender(MutableInt recommendCount) {
        this.recommendCount = recommendCount;
    }

    public List<RecommendedItem> recommend(long userID, int howMany) {
        this.recommendCount.increment();
        return Collections.singletonList(new GenericRecommendedItem(1L, 1.0f));
    }

    public List<RecommendedItem> recommend(long userID, int howMany, boolean includeKnownItems) {
        return this.recommend(userID, howMany);
    }

    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) {
        return this.recommend(userID, howMany);
    }

    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer, boolean includeKnownItems) {
        return this.recommend(userID, howMany);
    }

    public float estimatePreference(long userID, long itemID) {
        this.recommendCount.increment();
        return 0.0f;
    }

    public void setPreference(long userID, long itemID, float value) {
    }

    public void removePreference(long userID, long itemID) {
    }

    public DataModel getDataModel() {
        return TasteTestCase.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{1.0}, {2.0}, {3.0}});
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }
}

