/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.svd;

import java.util.List;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.recommender.svd.Factorization;
import org.apache.mahout.cf.taste.impl.recommender.svd.Factorizer;
import org.apache.mahout.cf.taste.impl.recommender.svd.SVDRecommender;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.CandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.easymock.EasyMock;
import org.junit.Test;

public class SVDRecommenderTest
extends TasteTestCase {
    @Test
    public void estimatePreference() throws Exception {
        DataModel dataModel = (DataModel)EasyMock.createMock(DataModel.class);
        Factorizer factorizer = (Factorizer)EasyMock.createMock(Factorizer.class);
        Factorization factorization = (Factorization)EasyMock.createMock(Factorization.class);
        EasyMock.expect((Object)factorizer.factorize()).andReturn((Object)factorization);
        EasyMock.expect((Object)factorization.getUserFeatures(1L)).andReturn((Object)new double[]{0.4, 2.0});
        EasyMock.expect((Object)factorization.getItemFeatures(5L)).andReturn((Object)new double[]{1.0, 0.3});
        EasyMock.replay((Object[])new Object[]{dataModel, factorizer, factorization});
        SVDRecommender svdRecommender = new SVDRecommender(dataModel, factorizer);
        float estimate = svdRecommender.estimatePreference(1L, 5L);
        SVDRecommenderTest.assertEquals((double)1.0, (double)estimate, (double)1.0E-6);
        EasyMock.verify((Object[])new Object[]{dataModel, factorizer, factorization});
    }

    @Test
    public void recommend() throws Exception {
        DataModel dataModel = (DataModel)EasyMock.createMock(DataModel.class);
        PreferenceArray preferencesFromUser = (PreferenceArray)EasyMock.createMock(PreferenceArray.class);
        CandidateItemsStrategy candidateItemsStrategy = (CandidateItemsStrategy)EasyMock.createMock(CandidateItemsStrategy.class);
        Factorizer factorizer = (Factorizer)EasyMock.createMock(Factorizer.class);
        Factorization factorization = (Factorization)EasyMock.createMock(Factorization.class);
        FastIDSet candidateItems = new FastIDSet();
        candidateItems.add(5L);
        candidateItems.add(3L);
        EasyMock.expect((Object)factorizer.factorize()).andReturn((Object)factorization);
        EasyMock.expect((Object)dataModel.getPreferencesFromUser(1L)).andReturn((Object)preferencesFromUser);
        EasyMock.expect((Object)candidateItemsStrategy.getCandidateItems(1L, preferencesFromUser, dataModel, false)).andReturn((Object)candidateItems);
        EasyMock.expect((Object)factorization.getUserFeatures(1L)).andReturn((Object)new double[]{0.4, 2.0});
        EasyMock.expect((Object)factorization.getItemFeatures(5L)).andReturn((Object)new double[]{1.0, 0.3});
        EasyMock.expect((Object)factorization.getUserFeatures(1L)).andReturn((Object)new double[]{0.4, 2.0});
        EasyMock.expect((Object)factorization.getItemFeatures(3L)).andReturn((Object)new double[]{2.0, 0.6});
        EasyMock.replay((Object[])new Object[]{dataModel, candidateItemsStrategy, factorizer, factorization});
        SVDRecommender svdRecommender = new SVDRecommender(dataModel, factorizer, candidateItemsStrategy);
        List recommendedItems = svdRecommender.recommend(1L, 5);
        SVDRecommenderTest.assertEquals((long)2L, (long)recommendedItems.size());
        SVDRecommenderTest.assertEquals((long)3L, (long)((RecommendedItem)recommendedItems.get(0)).getItemID());
        SVDRecommenderTest.assertEquals((double)2.0, (double)((RecommendedItem)recommendedItems.get(0)).getValue(), (double)1.0E-6);
        SVDRecommenderTest.assertEquals((long)5L, (long)((RecommendedItem)recommendedItems.get(1)).getItemID());
        SVDRecommenderTest.assertEquals((double)1.0, (double)((RecommendedItem)recommendedItems.get(1)).getValue(), (double)1.0E-6);
        EasyMock.verify((Object[])new Object[]{dataModel, candidateItemsStrategy, factorizer, factorization});
    }
}

