/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.common.Weighting;
import org.apache.mahout.cf.taste.impl.similarity.EuclideanDistanceSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.SimilarityTestCase;
import org.apache.mahout.cf.taste.model.DataModel;
import org.junit.Test;

public final class EuclideanDistanceSimilarityTest
extends SimilarityTestCase {
    @Test
    public void testFullCorrelation1() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -2.0}, {3.0, -2.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).userSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(1.0, correlation);
    }

    @Test
    public void testFullCorrelation1Weighted() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -2.0}, {3.0, -2.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel, Weighting.WEIGHTED).userSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(1.0, correlation);
    }

    @Test
    public void testFullCorrelation2() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, 3.0}, {3.0, 3.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).userSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertEquals((double)1.0, (double)correlation, (double)1.0E-6);
    }

    @Test
    public void testNoCorrelation1() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -2.0}, {-3.0, 2.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).userSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(0.1639607805437114, correlation);
    }

    @Test
    public void testNoCorrelation1Weighted() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -2.0}, {-3.0, 2.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel, Weighting.WEIGHTED).userSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(0.7213202601812372, correlation);
    }

    @Test
    public void testNoCorrelation2() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{null, 1.0, null}, {null, null, 1.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).userSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertTrue((boolean)Double.isNaN(correlation));
    }

    @Test
    public void testNoCorrelation3() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{90.0, 80.0, 70.0}, {70.0, 80.0, 90.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).userSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(0.05770363219029305, correlation);
    }

    @Test
    public void testSimple() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 6.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).userSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(0.2843646522044218, correlation);
    }

    @Test
    public void testSimpleWeighted() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 6.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel, Weighting.WEIGHTED).userSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(0.8210911630511055, correlation);
    }

    @Test
    public void testFullItemCorrelation1() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, 3.0}, {-2.0, -2.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).itemSimilarity(0L, 1L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(1.0, correlation);
    }

    @Test
    public void testFullItemCorrelation2() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, 3.0}, {3.0, 3.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).itemSimilarity(0L, 1L);
        EuclideanDistanceSimilarityTest.assertEquals((double)1.0, (double)correlation, (double)1.0E-6);
    }

    @Test
    public void testNoItemCorrelation1() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -3.0}, {-2.0, 2.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).itemSimilarity(0L, 1L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(0.1639607805437114, correlation);
    }

    @Test
    public void testNoItemCorrelation2() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{null, 1.0, null}, {null, null, 1.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).itemSimilarity(1L, 2L);
        EuclideanDistanceSimilarityTest.assertTrue((boolean)Double.isNaN(correlation));
    }

    @Test
    public void testNoItemCorrelation3() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{90.0, 70.0}, {80.0, 80.0}, {70.0, 90.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).itemSimilarity(0L, 1L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(0.05770363219029305, correlation);
    }

    @Test
    public void testSimpleItem() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{1.0, 2.0}, {2.0, 5.0}, {3.0, 6.0}});
        double correlation = new EuclideanDistanceSimilarity(dataModel).itemSimilarity(0L, 1L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(0.2843646522044218, correlation);
    }

    @Test
    public void testSimpleItemWeighted() throws Exception {
        DataModel dataModel = EuclideanDistanceSimilarityTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{1.0, 2.0}, {2.0, 5.0}, {3.0, 6.0}});
        EuclideanDistanceSimilarity itemSimilarity = new EuclideanDistanceSimilarity(dataModel, Weighting.WEIGHTED);
        double correlation = itemSimilarity.itemSimilarity(0L, 1L);
        EuclideanDistanceSimilarityTest.assertCorrelationEquals(0.8210911630511055, correlation);
    }

    @Test
    public void testRefresh() throws TasteException {
        new EuclideanDistanceSimilarity(EuclideanDistanceSimilarityTest.getDataModel()).refresh(null);
    }
}

