/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import org.apache.mahout.cf.taste.impl.similarity.LogLikelihoodSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.SimilarityTestCase;
import org.apache.mahout.cf.taste.model.DataModel;
import org.junit.Test;

public final class LogLikelihoodSimilarityTest
extends SimilarityTestCase {
    @Test
    public void testCorrelation() throws Exception {
        DataModel dataModel = LogLikelihoodSimilarityTest.getDataModel(new long[]{1L, 2L, 3L, 4L, 5L}, new Double[][]{{1.0, 1.0}, {1.0, null, 1.0}, {null, null, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0, 1.0}, {null, 1.0, 1.0, 1.0, 1.0}});
        LogLikelihoodSimilarity similarity = new LogLikelihoodSimilarity(dataModel);
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.12160727029227925, similarity.itemSimilarity(1L, 0L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.12160727029227925, similarity.itemSimilarity(0L, 1L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.5423213660693732, similarity.itemSimilarity(1L, 2L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.5423213660693732, similarity.itemSimilarity(2L, 1L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.6905400104897509, similarity.itemSimilarity(2L, 3L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.6905400104897509, similarity.itemSimilarity(3L, 2L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.8706358464330881, similarity.itemSimilarity(3L, 4L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.8706358464330881, similarity.itemSimilarity(4L, 3L));
    }

    @Test
    public void testNoSimilarity() throws Exception {
        DataModel dataModel = LogLikelihoodSimilarityTest.getDataModel(new long[]{1L, 2L, 3L, 4L}, new Double[][]{{1.0, null, 1.0, 1.0}, {1.0, null, 1.0, 1.0}, {null, 1.0, 1.0, 1.0}, {null, 1.0, 1.0, 1.0}});
        LogLikelihoodSimilarity similarity = new LogLikelihoodSimilarity(dataModel);
        LogLikelihoodSimilarityTest.assertCorrelationEquals(Double.NaN, similarity.itemSimilarity(1L, 0L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(Double.NaN, similarity.itemSimilarity(0L, 1L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.0, similarity.itemSimilarity(2L, 3L));
        LogLikelihoodSimilarityTest.assertCorrelationEquals(0.0, similarity.itemSimilarity(3L, 2L));
    }

    @Test
    public void testRefresh() {
        new LogLikelihoodSimilarity(LogLikelihoodSimilarityTest.getDataModel()).refresh(null);
    }
}

