/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.Weighting;
import org.apache.mahout.cf.taste.impl.similarity.PearsonCorrelationSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.SimilarityTestCase;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.PreferenceInferrer;
import org.junit.Test;

public final class PearsonCorrelationSimilarityTest
extends SimilarityTestCase {
    @Test
    public void testFullCorrelation1() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -2.0}, {3.0, -2.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(1.0, correlation);
    }

    @Test
    public void testFullCorrelation1Weighted() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -2.0}, {3.0, -2.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel, Weighting.WEIGHTED).userSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(1.0, correlation);
    }

    @Test
    public void testFullCorrelation2() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, 3.0}, {3.0, 3.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertTrue((boolean)Double.isNaN(correlation));
    }

    @Test
    public void testNoCorrelation1() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -2.0}, {-3.0, 2.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(-1.0, correlation);
    }

    @Test
    public void testNoCorrelation1Weighted() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -2.0}, {-3.0, 2.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel, Weighting.WEIGHTED).userSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(-1.0, correlation);
    }

    @Test
    public void testNoCorrelation2() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{null, 1.0, null}, {null, null, 1.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertTrue((boolean)Double.isNaN(correlation));
    }

    @Test
    public void testNoCorrelation3() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{90.0, 80.0, 70.0}, {70.0, 80.0, 90.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(-1.0, correlation);
    }

    @Test
    public void testSimple() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 6.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(0.9607689228305227, correlation);
    }

    @Test
    public void testSimpleWeighted() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 6.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel, Weighting.WEIGHTED).userSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(0.9901922307076306, correlation);
    }

    @Test
    public void testFullItemCorrelation1() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, 3.0}, {-2.0, -2.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).itemSimilarity(0L, 1L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(1.0, correlation);
    }

    @Test
    public void testFullItemCorrelation2() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, 3.0}, {3.0, 3.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).itemSimilarity(0L, 1L);
        PearsonCorrelationSimilarityTest.assertTrue((boolean)Double.isNaN(correlation));
    }

    @Test
    public void testNoItemCorrelation1() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{3.0, -3.0}, {2.0, -2.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).itemSimilarity(0L, 1L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(-1.0, correlation);
    }

    @Test
    public void testNoItemCorrelation2() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{null, 1.0, null}, {null, null, 1.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).itemSimilarity(1L, 2L);
        PearsonCorrelationSimilarityTest.assertTrue((boolean)Double.isNaN(correlation));
    }

    @Test
    public void testNoItemCorrelation3() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{90.0, 70.0}, {80.0, 80.0}, {70.0, 90.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).itemSimilarity(0L, 1L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(-1.0, correlation);
    }

    @Test
    public void testSimpleItem() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{1.0, 2.0}, {2.0, 5.0}, {3.0, 6.0}});
        double correlation = new PearsonCorrelationSimilarity(dataModel).itemSimilarity(0L, 1L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(0.9607689228305227, correlation);
    }

    @Test
    public void testSimpleItemWeighted() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{1.0, 2.0}, {2.0, 5.0}, {3.0, 6.0}});
        PearsonCorrelationSimilarity itemSimilarity = new PearsonCorrelationSimilarity(dataModel, Weighting.WEIGHTED);
        double correlation = itemSimilarity.itemSimilarity(0L, 1L);
        PearsonCorrelationSimilarityTest.assertCorrelationEquals(0.9901922307076306, correlation);
    }

    @Test
    public void testRefresh() throws Exception {
        new PearsonCorrelationSimilarity(PearsonCorrelationSimilarityTest.getDataModel()).refresh(null);
    }

    @Test
    public void testInferrer() throws Exception {
        DataModel dataModel = PearsonCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{null, 1.0, 2.0, null, null, 6.0}, {1.0, 8.0, null, 3.0, 4.0, null}});
        PearsonCorrelationSimilarity similarity = new PearsonCorrelationSimilarity(dataModel);
        similarity.setPreferenceInferrer(new PreferenceInferrer(){

            public float inferPreference(long userID, long itemID) {
                return 1.0f;
            }

            public void refresh(Collection<Refreshable> alreadyRefreshed) {
            }
        });
        PearsonCorrelationSimilarityTest.assertEquals((double)-0.435285750066007, (double)similarity.userSimilarity(1L, 2L), (double)1.0E-6);
    }
}

