/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import org.apache.mahout.cf.taste.impl.similarity.SimilarityTestCase;
import org.apache.mahout.cf.taste.impl.similarity.SpearmanCorrelationSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.junit.Test;

public final class SpearmanCorrelationSimilarityTest
extends SimilarityTestCase {
    @Test
    public void testFullCorrelation1() throws Exception {
        DataModel dataModel = SpearmanCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0, 2.0, 3.0}, {1.0, 2.0, 3.0}});
        double correlation = new SpearmanCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        SpearmanCorrelationSimilarityTest.assertCorrelationEquals(1.0, correlation);
    }

    @Test
    public void testFullCorrelation2() throws Exception {
        DataModel dataModel = SpearmanCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}});
        double correlation = new SpearmanCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        SpearmanCorrelationSimilarityTest.assertCorrelationEquals(1.0, correlation);
    }

    @Test
    public void testAnticorrelation() throws Exception {
        DataModel dataModel = SpearmanCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0, 2.0, 3.0}, {3.0, 2.0, 1.0}});
        double correlation = new SpearmanCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        SpearmanCorrelationSimilarityTest.assertCorrelationEquals(-1.0, correlation);
    }

    @Test
    public void testSimple() throws Exception {
        DataModel dataModel = SpearmanCorrelationSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0, 2.0, 3.0}, {2.0, 3.0, 1.0}});
        double correlation = new SpearmanCorrelationSimilarity(dataModel).userSimilarity(1L, 2L);
        SpearmanCorrelationSimilarityTest.assertCorrelationEquals(-0.5, correlation);
    }

    @Test
    public void testRefresh() {
        new SpearmanCorrelationSimilarity(SpearmanCorrelationSimilarityTest.getDataModel()).refresh(null);
    }
}

