/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import org.apache.mahout.cf.taste.impl.similarity.SimilarityTestCase;
import org.apache.mahout.cf.taste.impl.similarity.TanimotoCoefficientSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.junit.Test;

public final class TanimotoCoefficientSimilarityTest
extends SimilarityTestCase {
    @Test
    public void testNoCorrelation() throws Exception {
        DataModel dataModel = TanimotoCoefficientSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{null, 2.0, 3.0}, {1.0}});
        double correlation = new TanimotoCoefficientSimilarity(dataModel).userSimilarity(1L, 2L);
        TanimotoCoefficientSimilarityTest.assertCorrelationEquals(Double.NaN, correlation);
    }

    @Test
    public void testFullCorrelation1() throws Exception {
        DataModel dataModel = TanimotoCoefficientSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0}, {1.0}});
        double correlation = new TanimotoCoefficientSimilarity(dataModel).userSimilarity(1L, 2L);
        TanimotoCoefficientSimilarityTest.assertCorrelationEquals(1.0, correlation);
    }

    @Test
    public void testFullCorrelation2() throws Exception {
        DataModel dataModel = TanimotoCoefficientSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{1.0, 2.0, 3.0}, {1.0}});
        double correlation = new TanimotoCoefficientSimilarity(dataModel).userSimilarity(1L, 2L);
        TanimotoCoefficientSimilarityTest.assertCorrelationEquals(0.3333333333333333, correlation);
    }

    @Test
    public void testCorrelation1() throws Exception {
        DataModel dataModel = TanimotoCoefficientSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{null, 2.0, 3.0}, {1.0, 1.0}});
        double correlation = new TanimotoCoefficientSimilarity(dataModel).userSimilarity(1L, 2L);
        TanimotoCoefficientSimilarityTest.assertEquals((double)0.3333333333333333, (double)correlation, (double)1.0E-6);
    }

    @Test
    public void testCorrelation2() throws Exception {
        DataModel dataModel = TanimotoCoefficientSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{null, 2.0, 3.0, 1.0}, {1.0, 1.0, null, 0.0}});
        double correlation = new TanimotoCoefficientSimilarity(dataModel).userSimilarity(1L, 2L);
        TanimotoCoefficientSimilarityTest.assertEquals((double)0.5, (double)correlation, (double)1.0E-6);
    }

    @Test
    public void testRefresh() {
        new TanimotoCoefficientSimilarity(TanimotoCoefficientSimilarityTest.getDataModel()).refresh(null);
    }

    @Test
    public void testReturnNaNDoubleWhenNoSimilaritiesForTwoItems() throws Exception {
        DataModel dataModel = TanimotoCoefficientSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{null, null, 3.0}, {1.0, 1.0, null}});
        Double similarity = new TanimotoCoefficientSimilarity(dataModel).itemSimilarity(1L, 2L);
        TanimotoCoefficientSimilarityTest.assertEquals((double)Double.NaN, (double)similarity, (double)1.0E-6);
    }

    @Test
    public void testItemsSimilarities() throws Exception {
        DataModel dataModel = TanimotoCoefficientSimilarityTest.getDataModel(new long[]{1L, 2L}, new Double[][]{{2.0, null, 2.0}, {1.0, 1.0, 1.0}});
        TanimotoCoefficientSimilarity tCS = new TanimotoCoefficientSimilarity(dataModel);
        TanimotoCoefficientSimilarityTest.assertEquals((double)0.5, (double)tCS.itemSimilarity(0L, 1L), (double)1.0E-6);
        TanimotoCoefficientSimilarityTest.assertEquals((double)1.0, (double)tCS.itemSimilarity(0L, 2L), (double)1.0E-6);
        double[] similarities = tCS.itemSimilarities(0L, new long[]{1L, 2L});
        TanimotoCoefficientSimilarityTest.assertEquals((double)0.5, (double)similarities[0], (double)1.0E-6);
        TanimotoCoefficientSimilarityTest.assertEquals((double)1.0, (double)similarities[1], (double)1.0E-6);
    }
}

