/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity.precompute;

import java.io.IOException;
import java.util.Arrays;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.TanimotoCoefficientSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.precompute.MultithreadedBatchItemSimilarities;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.ItemBasedRecommender;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.cf.taste.similarity.precompute.SimilarItemsWriter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MultithreadedBatchItemSimilaritiesTest {
    @Test
    public void lessItemsThanBatchSize() throws Exception {
        FastByIDMap userData = new FastByIDMap();
        userData.put(1L, (Object)new GenericUserPreferenceArray(Arrays.asList(new GenericPreference(1L, 1L, 1.0f), new GenericPreference(1L, 2L, 1.0f), new GenericPreference(1L, 3L, 1.0f))));
        userData.put(2L, (Object)new GenericUserPreferenceArray(Arrays.asList(new GenericPreference(2L, 1L, 1.0f), new GenericPreference(2L, 2L, 1.0f), new GenericPreference(2L, 4L, 1.0f))));
        GenericDataModel dataModel = new GenericDataModel(userData);
        GenericItemBasedRecommender recommender = new GenericItemBasedRecommender((DataModel)dataModel, (ItemSimilarity)new TanimotoCoefficientSimilarity((DataModel)dataModel));
        MultithreadedBatchItemSimilarities batchSimilarities = new MultithreadedBatchItemSimilarities((ItemBasedRecommender)recommender, 10);
        batchSimilarities.computeItemSimilarities(1, 1, (SimilarItemsWriter)Mockito.mock(SimilarItemsWriter.class));
    }

    @Test
    public void higherDegreeOfParallelismThanBatches() throws Exception {
        FastByIDMap userData = new FastByIDMap();
        userData.put(1L, (Object)new GenericUserPreferenceArray(Arrays.asList(new GenericPreference(1L, 1L, 1.0f), new GenericPreference(1L, 2L, 1.0f), new GenericPreference(1L, 3L, 1.0f))));
        userData.put(2L, (Object)new GenericUserPreferenceArray(Arrays.asList(new GenericPreference(2L, 1L, 1.0f), new GenericPreference(2L, 2L, 1.0f), new GenericPreference(2L, 4L, 1.0f))));
        GenericDataModel dataModel = new GenericDataModel(userData);
        GenericItemBasedRecommender recommender = new GenericItemBasedRecommender((DataModel)dataModel, (ItemSimilarity)new TanimotoCoefficientSimilarity((DataModel)dataModel));
        MultithreadedBatchItemSimilarities batchSimilarities = new MultithreadedBatchItemSimilarities((ItemBasedRecommender)recommender, 10);
        try {
            batchSimilarities.computeItemSimilarities(2, 1, (SimilarItemsWriter)Mockito.mock(SimilarItemsWriter.class));
            Assert.fail();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

