/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mahout.classifier.RegressionResultAnalyzer;
import org.apache.mahout.common.MahoutTestCase;
import org.junit.Test;

public class RegressionResultAnalyzerTest
extends MahoutTestCase {
    private static final Pattern p1 = Pattern.compile("Correlation coefficient *: *(.*)\n");
    private static final Pattern p2 = Pattern.compile("Mean absolute error *: *(.*)\n");
    private static final Pattern p3 = Pattern.compile("Root mean squared error *: *(.*)\n");
    private static final Pattern p4 = Pattern.compile("Predictable Instances *: *(.*)\n");
    private static final Pattern p5 = Pattern.compile("Unpredictable Instances *: *(.*)\n");
    private static final Pattern p6 = Pattern.compile("Total Regressed Instances *: *(.*)\n");

    private static double[] parseAnalysis(CharSequence analysis) {
        double[] results = new double[3];
        Matcher m = p1.matcher(analysis);
        if (!m.find()) {
            return null;
        }
        results[0] = Double.parseDouble(m.group(1));
        m = p2.matcher(analysis);
        if (!m.find()) {
            return null;
        }
        results[1] = Double.parseDouble(m.group(1));
        m = p3.matcher(analysis);
        if (!m.find()) {
            return null;
        }
        results[2] = Double.parseDouble(m.group(1));
        return results;
    }

    private static int[] parseAnalysisCount(CharSequence analysis) {
        int[] results = new int[3];
        Matcher m = p4.matcher(analysis);
        if (m.find()) {
            results[0] = Integer.parseInt(m.group(1));
        }
        if ((m = p5.matcher(analysis)).find()) {
            results[1] = Integer.parseInt(m.group(1));
        }
        if ((m = p6.matcher(analysis)).find()) {
            results[2] = Integer.parseInt(m.group(1));
        }
        return results;
    }

    @Test
    public void testAnalyze() {
        int i;
        double[][] results = new double[10][2];
        for (int i2 = 0; i2 < results.length; ++i2) {
            results[i2][0] = i2;
            results[i2][1] = i2 + 1;
        }
        RegressionResultAnalyzer analyzer = new RegressionResultAnalyzer();
        analyzer.setInstances(results);
        String analysis = analyzer.toString();
        RegressionResultAnalyzerTest.assertArrayEquals((double[])new double[]{1.0, 1.0, 1.0}, (double[])RegressionResultAnalyzerTest.parseAnalysis(analysis), (double)0.0);
        for (i = 0; i < results.length; ++i) {
            results[i][1] = Math.sqrt(i);
        }
        analyzer = new RegressionResultAnalyzer();
        analyzer.setInstances(results);
        analysis = analyzer.toString();
        RegressionResultAnalyzerTest.assertArrayEquals((double[])new double[]{0.9573, 2.5694, 3.2848}, (double[])RegressionResultAnalyzerTest.parseAnalysis(analysis), (double)0.0);
        for (i = 0; i < results.length; ++i) {
            results[i][0] = results.length - i;
        }
        analyzer = new RegressionResultAnalyzer();
        analyzer.setInstances(results);
        analysis = analyzer.toString();
        RegressionResultAnalyzerTest.assertArrayEquals((double[])new double[]{-0.9573, 4.1351, 5.1573}, (double[])RegressionResultAnalyzerTest.parseAnalysis(analysis), (double)0.0);
    }

    @Test
    public void testUnpredictable() {
        double[][] results = new double[10][2];
        for (int i = 0; i < results.length; ++i) {
            results[i][0] = i;
            results[i][1] = Double.NaN;
        }
        RegressionResultAnalyzer analyzer = new RegressionResultAnalyzer();
        analyzer.setInstances(results);
        String analysis = analyzer.toString();
        RegressionResultAnalyzerTest.assertNull((Object)RegressionResultAnalyzerTest.parseAnalysis(analysis));
        RegressionResultAnalyzerTest.assertArrayEquals((int[])new int[]{0, 10, 10}, (int[])RegressionResultAnalyzerTest.parseAnalysisCount(analysis));
        for (int i = 0; i < results.length - 3; ++i) {
            results[i][1] = Math.sqrt(i);
        }
        analyzer = new RegressionResultAnalyzer();
        analyzer.setInstances(results);
        analysis = analyzer.toString();
        RegressionResultAnalyzerTest.assertArrayEquals((double[])new double[]{0.9552, 1.4526, 1.9345}, (double[])RegressionResultAnalyzerTest.parseAnalysis(analysis), (double)0.0);
        RegressionResultAnalyzerTest.assertArrayEquals((int[])new int[]{7, 3, 10}, (int[])RegressionResultAnalyzerTest.parseAnalysisCount(analysis));
    }
}

