/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.builder;

import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.mahout.classifier.df.builder.DefaultTreeBuilder;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Test;

public final class DefaultTreeBuilderTest
extends MahoutTestCase {
    @Test
    public void testRandomAttributes() throws Exception {
        RandomWrapper rng = RandomUtils.getRandom();
        int nbAttributes = rng.nextInt(100) + 1;
        boolean[] selected = new boolean[nbAttributes];
        for (int nloop = 0; nloop < 100; ++nloop) {
            Arrays.fill(selected, false);
            int nbSelected = rng.nextInt(nbAttributes - 1);
            for (int index = 0; index < nbSelected; ++index) {
                int attr;
                while (selected[attr = rng.nextInt(nbAttributes)]) {
                }
                selected[attr] = true;
            }
            int m = rng.nextInt(nbAttributes);
            int[] attrs = DefaultTreeBuilder.randomAttributes((Random)rng, (boolean[])selected, (int)m);
            DefaultTreeBuilderTest.assertNotNull((Object)attrs);
            DefaultTreeBuilderTest.assertEquals((long)Math.min(m, nbAttributes - nbSelected), (long)attrs.length);
            for (int attr : attrs) {
                DefaultTreeBuilderTest.assertFalse((String)"an attribute has already been selected", (boolean)selected[attr]);
                DefaultTreeBuilderTest.assertTrue((attr >= 0 ? 1 : 0) != 0);
                DefaultTreeBuilderTest.assertTrue((attr < nbAttributes ? 1 : 0) != 0);
                DefaultTreeBuilderTest.assertEquals((long)ArrayUtils.indexOf((int[])attrs, (int)attr), (long)ArrayUtils.lastIndexOf((int[])attrs, (int)attr));
            }
        }
    }
}

