/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.data;

import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.DescriptorException;
import org.apache.mahout.common.MahoutTestCase;
import org.junit.Test;

public final class DatasetTest
extends MahoutTestCase {
    @Test
    public void jsonEncoding() throws DescriptorException {
        Dataset to = DataLoader.generateDataset((CharSequence)"N C I L", (boolean)true, (String[])new String[]{"1 foo 2 3", "4 bar 5 6"});
        DatasetTest.assertEquals((long)3L, (long)to.nbAttributes());
        DatasetTest.assertEquals((long)1L, (long)to.getIgnored().length);
        DatasetTest.assertEquals((long)2L, (long)to.getIgnored()[0]);
        DatasetTest.assertEquals((long)2L, (long)to.getLabelId());
        DatasetTest.assertTrue((boolean)to.isNumerical(0));
        Dataset fromJson = Dataset.fromJSON((String)to.toJSON());
        DatasetTest.assertEquals((long)3L, (long)fromJson.nbAttributes());
        DatasetTest.assertEquals((long)1L, (long)fromJson.getIgnored().length);
        DatasetTest.assertEquals((long)2L, (long)fromJson.getIgnored()[0]);
        DatasetTest.assertTrue((boolean)fromJson.isNumerical(0));
        DatasetTest.assertNotEquals((long)fromJson.valueOf(1, "bar"), (long)fromJson.valueOf(1, "foo"));
    }

    @Test
    public void jsonEncodingIgnoreFeatures() throws DescriptorException {
        Dataset to = DataLoader.generateDataset((CharSequence)"N C I L", (boolean)false, (String[])new String[]{"1 foo 2 Red", "4 bar 5 Blue"});
        DatasetTest.assertEquals((long)3L, (long)to.nbAttributes());
        DatasetTest.assertEquals((long)1L, (long)to.getIgnored().length);
        DatasetTest.assertEquals((long)2L, (long)to.getIgnored()[0]);
        DatasetTest.assertEquals((long)2L, (long)to.getLabelId());
        DatasetTest.assertTrue((boolean)to.isNumerical(0));
        DatasetTest.assertNotEquals((long)to.valueOf(1, "bar"), (long)to.valueOf(1, "foo"));
        DatasetTest.assertNotEquals((long)to.valueOf(2, "Red"), (long)to.valueOf(2, "Blue"));
        Dataset fromJson = Dataset.fromJSON((String)to.toJSON());
        DatasetTest.assertEquals((long)3L, (long)fromJson.nbAttributes());
        DatasetTest.assertEquals((long)1L, (long)fromJson.getIgnored().length);
        DatasetTest.assertEquals((long)2L, (long)fromJson.getIgnored()[0]);
        DatasetTest.assertTrue((boolean)fromJson.isNumerical(0));
        DatasetTest.assertNotEquals((long)fromJson.valueOf(1, "bar"), (long)fromJson.valueOf(1, "foo"));
        DatasetTest.assertNotEquals((long)fromJson.valueOf(2, "Red"), (long)fromJson.valueOf(2, "Blue"));
    }
}

