/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.training;

import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.naivebayes.training.ComplementaryThetaTrainer;
import org.apache.mahout.classifier.naivebayes.training.ThetaMapper;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.easymock.EasyMock;
import org.junit.Test;

public class ThetaMapperTest
extends MahoutTestCase {
    @Test
    public void standard() throws Exception {
        Mapper.Context ctx = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        ComplementaryThetaTrainer trainer = (ComplementaryThetaTrainer)EasyMock.createMock(ComplementaryThetaTrainer.class);
        DenseVector instance1 = new DenseVector(new double[]{1.0, 2.0, 3.0});
        DenseVector instance2 = new DenseVector(new double[]{4.0, 5.0, 6.0});
        DenseVector perLabelThetaNormalizer = new DenseVector(new double[]{7.0, 8.0});
        ThetaMapper thetaMapper = new ThetaMapper();
        ThetaMapperTest.setField(thetaMapper, "trainer", trainer);
        trainer.train(0, (Vector)instance1);
        trainer.train(1, (Vector)instance2);
        EasyMock.expect((Object)trainer.retrievePerLabelThetaNormalizer()).andReturn((Object)perLabelThetaNormalizer);
        ctx.write((Object)new Text("_LTN"), (Object)new VectorWritable((Vector)perLabelThetaNormalizer));
        EasyMock.replay((Object[])new Object[]{ctx, trainer});
        thetaMapper.map(new IntWritable(0), new VectorWritable((Vector)instance1), ctx);
        thetaMapper.map(new IntWritable(1), new VectorWritable((Vector)instance2), ctx);
        thetaMapper.cleanup(ctx);
        EasyMock.verify((Object[])new Object[]{ctx, trainer});
    }
}

