/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import org.apache.mahout.classifier.sequencelearning.hmm.HMMTestBase;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmTrainer;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public class HMMTrainerTest
extends HMMTestBase {
    @Test
    public void testViterbiTraining() {
        double[][] transitionE = new double[][]{{0.3125, 0.0625, 0.3125, 0.3125}, {0.25, 0.25, 0.25, 0.25}, {0.5, 0.071429, 0.357143, 0.071429}, {0.5, 0.1, 0.1, 0.3}};
        double[][] emissionE = new double[][]{{0.882353, 0.058824, 0.058824}, {0.333333, 0.333333, 0.3333333}, {0.076923, 0.846154, 0.076923}, {0.111111, 0.111111, 0.777778}};
        int[] observed = new int[]{1, 0, 2, 2, 0, 0, 1, 1, 1, 0, 2, 0, 1, 0, 0};
        HmmModel trained = HmmTrainer.trainViterbi((HmmModel)this.getModel(), (int[])observed, (double)0.5, (double)0.1, (int)10, (boolean)false);
        Matrix emissionMatrix = trained.getEmissionMatrix();
        Matrix transitionMatrix = trained.getTransitionMatrix();
        for (int i = 0; i < trained.getNrOfHiddenStates(); ++i) {
            int j;
            for (j = 0; j < trained.getNrOfHiddenStates(); ++j) {
                HMMTrainerTest.assertEquals((double)transitionMatrix.getQuick(i, j), (double)transitionE[i][j], (double)1.0E-6);
            }
            for (j = 0; j < trained.getNrOfOutputStates(); ++j) {
                HMMTrainerTest.assertEquals((double)emissionMatrix.getQuick(i, j), (double)emissionE[i][j], (double)1.0E-6);
            }
        }
    }

    @Test
    public void testScaledViterbiTraining() {
        double[][] transitionE = new double[][]{{0.3125, 0.0625, 0.3125, 0.3125}, {0.25, 0.25, 0.25, 0.25}, {0.5, 0.071429, 0.357143, 0.071429}, {0.5, 0.1, 0.1, 0.3}};
        double[][] emissionE = new double[][]{{0.882353, 0.058824, 0.058824}, {0.333333, 0.333333, 0.3333333}, {0.076923, 0.846154, 0.076923}, {0.111111, 0.111111, 0.777778}};
        int[] observed = new int[]{1, 0, 2, 2, 0, 0, 1, 1, 1, 0, 2, 0, 1, 0, 0};
        HmmModel trained = HmmTrainer.trainViterbi((HmmModel)this.getModel(), (int[])observed, (double)0.5, (double)0.1, (int)10, (boolean)true);
        Matrix emissionMatrix = trained.getEmissionMatrix();
        Matrix transitionMatrix = trained.getTransitionMatrix();
        for (int i = 0; i < trained.getNrOfHiddenStates(); ++i) {
            int j;
            for (j = 0; j < trained.getNrOfHiddenStates(); ++j) {
                HMMTrainerTest.assertEquals((double)transitionMatrix.getQuick(i, j), (double)transitionE[i][j], (double)1.0E-6);
            }
            for (j = 0; j < trained.getNrOfOutputStates(); ++j) {
                HMMTrainerTest.assertEquals((double)emissionMatrix.getQuick(i, j), (double)emissionE[i][j], (double)1.0E-6);
            }
        }
    }

    @Test
    public void testBaumWelchTraining() {
        int[] observed = new int[]{1, 0, 2, 2, 0, 0, 1, 1, 1, 0, 2, 0, 1, 0, 0};
        double[] initialExpected = new double[]{0.0, 0.0, 1.0, 0.0};
        double[][] transitionExpected = new double[][]{{0.2319, 0.0993, 5.0E-4, 0.6683}, {1.0E-4, 0.3345, 0.6654, 0.0}, {0.5975, 0.0, 0.4025, 0.0}, {0.0024, 0.6657, 0.0, 0.3319}};
        double[][] emissionExpected = new double[][]{{0.9995, 4.0E-4, 1.0E-4}, {0.9943, 0.0036, 0.0021}, {0.0059, 0.9941, 0.0}, {0.0, 0.0, 1.0}};
        HmmModel trained = HmmTrainer.trainBaumWelch((HmmModel)this.getModel(), (int[])observed, (double)0.1, (int)10, (boolean)false);
        Vector initialProbabilities = trained.getInitialProbabilities();
        Matrix emissionMatrix = trained.getEmissionMatrix();
        Matrix transitionMatrix = trained.getTransitionMatrix();
        for (int i = 0; i < trained.getNrOfHiddenStates(); ++i) {
            int j;
            HMMTrainerTest.assertEquals((double)initialProbabilities.get(i), (double)initialExpected[i], (double)1.0E-4);
            for (j = 0; j < trained.getNrOfHiddenStates(); ++j) {
                HMMTrainerTest.assertEquals((double)transitionMatrix.getQuick(i, j), (double)transitionExpected[i][j], (double)1.0E-4);
            }
            for (j = 0; j < trained.getNrOfOutputStates(); ++j) {
                HMMTrainerTest.assertEquals((double)emissionMatrix.getQuick(i, j), (double)emissionExpected[i][j], (double)1.0E-4);
            }
        }
    }

    @Test
    public void testScaledBaumWelchTraining() {
        int[] observed = new int[]{1, 0, 2, 2, 0, 0, 1, 1, 1, 0, 2, 0, 1, 0, 0};
        double[] initialExpected = new double[]{0.0, 0.0, 1.0, 0.0};
        double[][] transitionExpected = new double[][]{{0.2319, 0.0993, 5.0E-4, 0.6683}, {1.0E-4, 0.3345, 0.6654, 0.0}, {0.5975, 0.0, 0.4025, 0.0}, {0.0024, 0.6657, 0.0, 0.3319}};
        double[][] emissionExpected = new double[][]{{0.9995, 4.0E-4, 1.0E-4}, {0.9943, 0.0036, 0.0021}, {0.0059, 0.9941, 0.0}, {0.0, 0.0, 1.0}};
        HmmModel trained = HmmTrainer.trainBaumWelch((HmmModel)this.getModel(), (int[])observed, (double)0.1, (int)10, (boolean)true);
        Vector initialProbabilities = trained.getInitialProbabilities();
        Matrix emissionMatrix = trained.getEmissionMatrix();
        Matrix transitionMatrix = trained.getTransitionMatrix();
        for (int i = 0; i < trained.getNrOfHiddenStates(); ++i) {
            int j;
            HMMTrainerTest.assertEquals((double)initialProbabilities.get(i), (double)initialExpected[i], (double)1.0E-4);
            for (j = 0; j < trained.getNrOfHiddenStates(); ++j) {
                HMMTrainerTest.assertEquals((double)transitionMatrix.getQuick(i, j), (double)transitionExpected[i][j], (double)1.0E-4);
            }
            for (j = 0; j < trained.getNrOfOutputStates(); ++j) {
                HMMTrainerTest.assertEquals((double)emissionMatrix.getQuick(i, j), (double)emissionExpected[i][j], (double)1.0E-4);
            }
        }
    }
}

