/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.kmeans;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.ClusteringTestUtils;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.kmeans.RandomSeedGenerator;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Before;
import org.junit.Test;

public final class TestRandomSeedGenerator
extends MahoutTestCase {
    private static final double[][] RAW = new double[][]{{1.0, 1.0}, {2.0, 1.0}, {1.0, 2.0}, {2.0, 2.0}, {3.0, 3.0}, {4.0, 4.0}, {5.0, 4.0}, {4.0, 5.0}, {5.0, 5.0}};
    private FileSystem fs;

    private static List<VectorWritable> getPoints() {
        ArrayList points = Lists.newArrayList();
        for (double[] fr : RAW) {
            RandomAccessSparseVector vec = new RandomAccessSparseVector(fr.length);
            vec.assign(fr);
            points.add(new VectorWritable((Vector)vec));
        }
        return points;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.getConfiguration();
        this.fs = FileSystem.get((Configuration)conf);
    }

    @Test
    public void testRandomSeedGenerator() throws Exception {
        List<VectorWritable> points = TestRandomSeedGenerator.getPoints();
        Job job = new Job();
        Configuration conf = job.getConfiguration();
        job.setMapOutputValueClass(VectorWritable.class);
        Path input = this.getTestTempFilePath("random-input");
        Path output = this.getTestTempDirPath("random-output");
        ClusteringTestUtils.writePointsToFile(points, input, this.fs, conf);
        RandomSeedGenerator.buildRandom((Configuration)conf, (Path)input, (Path)output, (int)4, (DistanceMeasure)new ManhattanDistanceMeasure());
        int clusterCount = 0;
        HashSet set = Sets.newHashSet();
        for (ClusterWritable clusterWritable : new SequenceFileValueIterable(new Path(output, "part-randomSeed"), true, conf)) {
            ++clusterCount;
            Cluster cluster = clusterWritable.getValue();
            int id = cluster.getId();
            TestRandomSeedGenerator.assertTrue((boolean)set.add(id));
            Vector v = cluster.getCenter();
            TestRandomSeedGenerator.assertVectorEquals(RAW[id], v);
        }
        TestRandomSeedGenerator.assertEquals((long)4L, (long)clusterCount);
    }

    @Test
    public void testRandomSeedGeneratorSeeded() throws Exception {
        List<VectorWritable> points = TestRandomSeedGenerator.getPoints();
        Job job = new Job();
        Configuration conf = job.getConfiguration();
        job.setMapOutputValueClass(VectorWritable.class);
        Path input = this.getTestTempFilePath("random-input");
        Path output = this.getTestTempDirPath("random-output");
        ClusteringTestUtils.writePointsToFile(points, input, this.fs, conf);
        RandomSeedGenerator.buildRandom((Configuration)conf, (Path)input, (Path)output, (int)4, (DistanceMeasure)new ManhattanDistanceMeasure(), (Long)1L);
        int clusterCount = 0;
        HashSet set = Sets.newHashSet();
        for (ClusterWritable clusterWritable : new SequenceFileValueIterable(new Path(output, "part-randomSeed"), true, conf)) {
            ++clusterCount;
            Cluster cluster = clusterWritable.getValue();
            int id = cluster.getId();
            TestRandomSeedGenerator.assertTrue((boolean)set.add(id));
            Vector v = cluster.getCenter();
            TestRandomSeedGenerator.assertVectorEquals(RAW[id], v);
        }
        TestRandomSeedGenerator.assertEquals((long)4L, (long)clusterCount);
    }

    @Test
    public void testBuildRandomSeededSameInitalClusters() throws Exception {
        Cluster cluster;
        List<VectorWritable> points = TestRandomSeedGenerator.getPoints();
        Job job = new Job();
        Configuration conf = job.getConfiguration();
        job.setMapOutputValueClass(VectorWritable.class);
        Path input = this.getTestTempFilePath("random-input");
        Path output = this.getTestTempDirPath("random-output");
        ClusteringTestUtils.writePointsToFile(points, input, this.fs, conf);
        long randSeed = 1L;
        RandomSeedGenerator.buildRandom((Configuration)conf, (Path)input, (Path)output, (int)4, (DistanceMeasure)new ManhattanDistanceMeasure(), (Long)randSeed);
        int[] clusterIDSeq = new int[4];
        int clusterCount = 0;
        for (ClusterWritable clusterWritable : new SequenceFileValueIterable(new Path(output, "part-randomSeed"), true, conf)) {
            cluster = clusterWritable.getValue();
            clusterIDSeq[clusterCount] = cluster.getId();
            ++clusterCount;
        }
        RandomSeedGenerator.buildRandom((Configuration)conf, (Path)input, (Path)output, (int)4, (DistanceMeasure)new ManhattanDistanceMeasure(), (Long)randSeed);
        clusterCount = 0;
        for (ClusterWritable clusterWritable : new SequenceFileValueIterable(new Path(output, "part-randomSeed"), true, conf)) {
            cluster = clusterWritable.getValue();
            TestRandomSeedGenerator.assertEquals((long)clusterIDSeq[clusterCount], (long)cluster.getId());
            ++clusterCount;
        }
    }

    private static void assertVectorEquals(double[] raw, Vector v) {
        TestRandomSeedGenerator.assertEquals((long)raw.length, (long)v.size());
        for (int i = 0; i < raw.length; ++i) {
            TestRandomSeedGenerator.assertEquals((double)raw[i], (double)v.getQuick(i), (double)1.0E-6);
        }
    }
}

