/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.spectral.AffinityMatrixInputMapper;
import org.apache.mahout.clustering.spectral.AffinityMatrixInputReducer;
import org.apache.mahout.common.DummyRecordWriter;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.junit.Test;

public class TestAffinityMatrixInputJob
extends MahoutTestCase {
    private static final String[] RAW = new String[]{"0,0,0", "0,1,5", "0,2,10", "1,0,5", "1,1,0", "1,2,20", "2,0,10", "2,1,20", "2,2,0"};
    private static final int RAW_DIMENSIONS = 3;

    @Test
    public void testAffinityMatrixInputMapper() throws Exception {
        AffinityMatrixInputMapper mapper = new AffinityMatrixInputMapper();
        Configuration conf = this.getConfiguration();
        conf.setInt("org.apache.mahout.clustering.spectral.common.affinitydimensions", 3);
        DummyRecordWriter writer = new DummyRecordWriter();
        Mapper.Context context = DummyRecordWriter.build(mapper, conf, writer);
        for (String s : RAW) {
            mapper.map(new LongWritable(), new Text(s), context);
        }
        TestAffinityMatrixInputJob.assertEquals((String)"Number of map results", (long)3L, (long)writer.getData().size());
        Set keys = writer.getData().keySet();
        for (IntWritable i : keys) {
            List row = writer.getData().get(i);
            TestAffinityMatrixInputJob.assertEquals((String)"Number of items in row", (long)3L, (long)row.size());
        }
    }

    @Test
    public void testAffinitymatrixInputReducer() throws Exception {
        AffinityMatrixInputMapper mapper = new AffinityMatrixInputMapper();
        Configuration conf = this.getConfiguration();
        conf.setInt("org.apache.mahout.clustering.spectral.common.affinitydimensions", 3);
        DummyRecordWriter mapWriter = new DummyRecordWriter();
        Mapper.Context mapContext = DummyRecordWriter.build(mapper, conf, mapWriter);
        for (String s : RAW) {
            mapper.map(new LongWritable(), new Text(s), mapContext);
        }
        Map map = mapWriter.getData();
        AffinityMatrixInputReducer reducer = new AffinityMatrixInputReducer();
        DummyRecordWriter redWriter = new DummyRecordWriter();
        Reducer.Context redContext = DummyRecordWriter.build(reducer, conf, redWriter, IntWritable.class, DistributedRowMatrix.MatrixEntryWritable.class);
        for (IntWritable key : mapWriter.getKeys()) {
            reducer.reduce(key, mapWriter.getValue(key), redContext);
        }
        TestAffinityMatrixInputJob.assertEquals((String)"Number of reduce results", (long)3L, (long)redWriter.getData().size());
        for (IntWritable row : redWriter.getKeys()) {
            List list = redWriter.getValue(row);
            TestAffinityMatrixInputJob.assertEquals((String)"Should only be one vector", (long)1L, (long)list.size());
            Vector v = ((VectorWritable)list.get(0)).get();
            for (Vector.Element e : v.all()) {
                DistributedRowMatrix.MatrixEntryWritable toCompare = new DistributedRowMatrix.MatrixEntryWritable();
                toCompare.setRow(-1);
                toCompare.setCol(e.index());
                toCompare.setVal(e.get());
                TestAffinityMatrixInputJob.assertTrue((String)"This entry was correctly placed in its row", (boolean)map.get(row).contains(toCompare));
            }
        }
    }
}

