/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.streaming.cluster;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.common.Pair;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.random.MultiNormal;

public final class DataUtils {
    private DataUtils() {
    }

    public static Pair<List<Centroid>, List<Centroid>> sampleMultiNormalHypercube(int numDimensions, int numDatapoints, double distributionRadius) {
        int pow2N = 1 << numDimensions;
        ArrayList mean = Lists.newArrayListWithCapacity((int)pow2N);
        ArrayList rowSamplers = Lists.newArrayList();
        for (int i = 0; i < pow2N; ++i) {
            DenseVector v = new DenseVector(numDimensions);
            int pow2J = 1 << numDimensions - 1;
            for (int j = 0; j < numDimensions; ++j) {
                v.set(j, 1.0 / (double)pow2J * (double)(i & pow2J));
                pow2J >>= 1;
            }
            mean.add(new Centroid(i, (Vector)v, 1.0));
            rowSamplers.add(new MultiNormal(distributionRadius, (Vector)v));
        }
        ArrayList data = Lists.newArrayListWithCapacity((int)numDatapoints);
        for (int i = 0; i < numDatapoints; ++i) {
            data.add(new Centroid(i, ((MultiNormal)rowSamplers.get(i % pow2N)).sample(), 1.0));
        }
        return new Pair((Object)data, (Object)mean);
    }

    public static Pair<List<Centroid>, List<Centroid>> sampleMultiNormalHypercube(int numDimensions, int numDatapoints) {
        return DataUtils.sampleMultiNormalHypercube(numDimensions, numDatapoints, 0.01);
    }
}

