/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Arrays;
import org.apache.mahout.common.IntPairWritable;
import org.apache.mahout.common.MahoutTestCase;
import org.junit.Test;

public final class IntPairWritableTest
extends MahoutTestCase {
    @Test
    public void testGetSet() {
        IntPairWritable n = new IntPairWritable();
        IntPairWritableTest.assertEquals((long)0L, (long)n.getFirst());
        IntPairWritableTest.assertEquals((long)0L, (long)n.getSecond());
        n.setFirst(5);
        n.setSecond(10);
        IntPairWritableTest.assertEquals((long)5L, (long)n.getFirst());
        IntPairWritableTest.assertEquals((long)10L, (long)n.getSecond());
        n = new IntPairWritable(2, 4);
        IntPairWritableTest.assertEquals((long)2L, (long)n.getFirst());
        IntPairWritableTest.assertEquals((long)4L, (long)n.getSecond());
    }

    @Test
    public void testWritable() throws Exception {
        IntPairWritable one = new IntPairWritable(1, 2);
        IntPairWritable two = new IntPairWritable(3, 4);
        IntPairWritableTest.assertEquals((long)1L, (long)one.getFirst());
        IntPairWritableTest.assertEquals((long)2L, (long)one.getSecond());
        IntPairWritableTest.assertEquals((long)3L, (long)two.getFirst());
        IntPairWritableTest.assertEquals((long)4L, (long)two.getSecond());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        two.write((DataOutput)out);
        byte[] b = bout.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        DataInputStream din = new DataInputStream(bin);
        one.readFields((DataInput)din);
        IntPairWritableTest.assertEquals((long)two.getFirst(), (long)one.getFirst());
        IntPairWritableTest.assertEquals((long)two.getSecond(), (long)one.getSecond());
    }

    @Test
    public void testComparable() {
        IntPairWritable[] input = new IntPairWritable[]{new IntPairWritable(2, 3), new IntPairWritable(2, 2), new IntPairWritable(1, 3), new IntPairWritable(1, 2), new IntPairWritable(2, 1), new IntPairWritable(2, 2), new IntPairWritable(1, -2), new IntPairWritable(1, -1), new IntPairWritable(-2, -2), new IntPairWritable(-2, -1), new IntPairWritable(-1, -1), new IntPairWritable(-1, -2), new IntPairWritable(Integer.MAX_VALUE, 1), new IntPairWritable(0x3FFFFFFF, 1), new IntPairWritable(Integer.MIN_VALUE, 1), new IntPairWritable(-1073741824, 1)};
        Object[] sorted = new IntPairWritable[input.length];
        System.arraycopy(input, 0, sorted, 0, input.length);
        Arrays.sort(sorted);
        int[] expected = new int[]{14, 15, 8, 9, 11, 10, 6, 7, 3, 2, 4, 1, 5, 0, 13, 12};
        for (int i = 0; i < input.length; ++i) {
            IntPairWritableTest.assertSame((Object)input[expected[i]], (Object)sorted[i]);
        }
    }
}

