/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.RandomUtils;
import org.junit.After;
import org.junit.Before;

public class MahoutTestCase
extends org.apache.mahout.math.MahoutTestCase {
    public static final double EPSILON = 1.0E-6;
    private Path testTempDirPath;
    private FileSystem fs;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        RandomUtils.useTestSeed();
        this.testTempDirPath = null;
        this.fs = null;
    }

    @After
    public void tearDown() throws Exception {
        if (this.testTempDirPath != null) {
            try {
                this.fs.delete(this.testTempDirPath, true);
            }
            catch (IOException e) {
                throw new IllegalStateException("Test file not found");
            }
            this.testTempDirPath = null;
            this.fs = null;
        }
        super.tearDown();
    }

    public final Configuration getConfiguration() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hadoop.tmp.dir", this.getTestTempDir("hadoop" + Math.random()).getAbsolutePath());
        return conf;
    }

    protected final Path getTestTempDirPath() throws IOException {
        if (this.testTempDirPath == null) {
            this.fs = FileSystem.get((Configuration)this.getConfiguration());
            long simpleRandomLong = (long)(9.223372036854776E18 * Math.random());
            this.testTempDirPath = this.fs.makeQualified(new Path("/tmp/mahout-" + ((Object)((Object)this)).getClass().getSimpleName() + '-' + simpleRandomLong));
            if (!this.fs.mkdirs(this.testTempDirPath)) {
                throw new IOException("Could not create " + this.testTempDirPath);
            }
            this.fs.deleteOnExit(this.testTempDirPath);
        }
        return this.testTempDirPath;
    }

    protected final Path getTestTempFilePath(String name) throws IOException {
        return this.getTestTempFileOrDirPath(name, false);
    }

    protected final Path getTestTempDirPath(String name) throws IOException {
        return this.getTestTempFileOrDirPath(name, true);
    }

    private Path getTestTempFileOrDirPath(String name, boolean dir) throws IOException {
        Path testTempDirPath = this.getTestTempDirPath();
        Path tempFileOrDir = this.fs.makeQualified(new Path(testTempDirPath, name));
        this.fs.deleteOnExit(tempFileOrDir);
        if (dir && !this.fs.mkdirs(tempFileOrDir)) {
            throw new IOException("Could not create " + tempFileOrDir);
        }
        return tempFileOrDir;
    }

    protected static void setField(Object target, String fieldname, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field field = MahoutTestCase.findDeclaredField(target.getClass(), fieldname);
        field.setAccessible(true);
        field.set(target, value);
    }

    private static Field findDeclaredField(Class<?> inClass, String fieldname) throws NoSuchFieldException {
        while (!Object.class.equals(inClass)) {
            for (Field field : inClass.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(fieldname)) continue;
                return field;
            }
            inClass = inClass.getSuperclass();
        }
        throw new NoSuchFieldException();
    }

    protected static String optKey(String optionName) {
        return AbstractJob.keyFor((String)optionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeLines(File file, String ... lines) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
        try {
            for (String line : lines) {
                writer.write(line);
                ((Writer)writer).write(10);
            }
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
    }
}

