/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.iterator.CountingIterator;
import org.junit.Test;

public abstract class SamplerCase
extends MahoutTestCase {
    protected abstract Iterator<Integer> createSampler(int var1, Iterator<Integer> var2);

    protected abstract boolean isSorted();

    @Test
    public void testEmptyCase() {
        SamplerCase.assertFalse((boolean)this.createSampler(100, (Iterator<Integer>)new CountingIterator(0)).hasNext());
    }

    @Test
    public void testSmallInput() {
        Iterator<Integer> t = this.createSampler(10, (Iterator<Integer>)new CountingIterator(1));
        SamplerCase.assertTrue((boolean)t.hasNext());
        SamplerCase.assertEquals((long)0L, (long)t.next().intValue());
        SamplerCase.assertFalse((boolean)t.hasNext());
        t = this.createSampler(10, (Iterator<Integer>)new CountingIterator(1));
        SamplerCase.assertTrue((boolean)t.hasNext());
        SamplerCase.assertEquals((long)0L, (long)t.next().intValue());
        SamplerCase.assertFalse((boolean)t.hasNext());
    }

    @Test
    public void testAbsurdSize() {
        Iterator<Integer> t = this.createSampler(0, (Iterator<Integer>)new CountingIterator(2));
        SamplerCase.assertFalse((boolean)t.hasNext());
    }

    @Test
    public void testExactSizeMatch() {
        Iterator<Integer> t = this.createSampler(10, (Iterator<Integer>)new CountingIterator(10));
        for (int i = 0; i < 10; ++i) {
            SamplerCase.assertTrue((boolean)t.hasNext());
            SamplerCase.assertEquals((long)i, (long)t.next().intValue());
        }
        SamplerCase.assertFalse((boolean)t.hasNext());
    }

    @Test
    public void testSample() {
        CountingIterator source = new CountingIterator(100);
        Iterator<Integer> t = this.createSampler(15, (Iterator<Integer>)source);
        List<Integer> expectedValues = Arrays.asList(52, 28, 2, 60, 50, 32, 65, 79, 78, 9, 40, 33, 96, 25, 48);
        if (this.isSorted()) {
            Collections.sort(expectedValues);
        }
        Iterator<Integer> expected = expectedValues.iterator();
        int last = Integer.MIN_VALUE;
        for (int i = 0; i < 15; ++i) {
            SamplerCase.assertTrue((boolean)t.hasNext());
            int actual = t.next();
            if (this.isSorted()) {
                SamplerCase.assertTrue((actual >= last ? 1 : 0) != 0);
                last = actual;
            } else if (actual < 15) {
                SamplerCase.assertEquals((long)i, (long)actual);
            }
            SamplerCase.assertTrue((actual >= 0 && actual < 100 ? 1 : 0) != 0);
            SamplerCase.assertEquals((long)expected.next().intValue(), (long)actual);
            SamplerCase.assertFalse((boolean)source.hasNext());
        }
        SamplerCase.assertFalse((boolean)t.hasNext());
    }
}

