/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import java.util.Iterator;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.iterator.CountingIterator;
import org.apache.mahout.common.iterator.SamplingIterator;
import org.junit.Test;

public final class TestSamplingIterator
extends MahoutTestCase {
    @Test
    public void testEmptyCase() {
        TestSamplingIterator.assertFalse((boolean)new SamplingIterator((Iterator)new CountingIterator(0), 0.9999).hasNext());
        TestSamplingIterator.assertFalse((boolean)new SamplingIterator((Iterator)new CountingIterator(0), 1.0).hasNext());
    }

    @Test
    public void testSmallInput() {
        SamplingIterator t = new SamplingIterator((Iterator)new CountingIterator(1), 0.9999);
        TestSamplingIterator.assertTrue((boolean)t.hasNext());
        TestSamplingIterator.assertEquals((long)0L, (long)((Integer)t.next()).intValue());
        TestSamplingIterator.assertFalse((boolean)t.hasNext());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadRate1() {
        new SamplingIterator((Iterator)new CountingIterator(1), 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadRate2() {
        new SamplingIterator((Iterator)new CountingIterator(1), 1.1);
    }

    @Test
    public void testExactSizeMatch() {
        SamplingIterator t = new SamplingIterator((Iterator)new CountingIterator(10), 1.0);
        for (int i = 0; i < 10; ++i) {
            TestSamplingIterator.assertTrue((boolean)t.hasNext());
            TestSamplingIterator.assertEquals((long)i, (long)((Integer)t.next()).intValue());
        }
        TestSamplingIterator.assertFalse((boolean)t.hasNext());
    }

    @Test
    public void testSample() {
        for (int i = 0; i < 1000; ++i) {
            SamplingIterator t = new SamplingIterator((Iterator)new CountingIterator(1000), 0.1);
            int k = 0;
            while (t.hasNext()) {
                int v = (Integer)t.next();
                ++k;
                TestSamplingIterator.assertTrue((v >= 0 ? 1 : 0) != 0);
                TestSamplingIterator.assertTrue((v < 1000 ? 1 : 0) != 0);
            }
            double sd = Math.sqrt(90.00000000000001);
            TestSamplingIterator.assertTrue(((double)k >= 100.0 - 4.0 * sd ? 1 : 0) != 0);
            TestSamplingIterator.assertTrue(((double)k <= 100.0 + 4.0 * sd ? 1 : 0) != 0);
        }
    }
}

