/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenIntObjectHashMap;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.junit.Assert;

public final class MathHelper {
    private MathHelper() {
    }

    public static Vector.Element elem(int index, double value) {
        return new ElementToCheck(index, value);
    }

    public static VectorWritable vectorMatches(final Vector.Element ... elements) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public boolean matches(Object argument) {
                if (argument instanceof VectorWritable) {
                    Vector v = ((VectorWritable)argument).get();
                    return MathHelper.consistsOf(v, elements);
                }
                return false;
            }

            public void appendTo(StringBuffer buffer) {
            }
        });
        return null;
    }

    public static boolean consistsOf(Vector vector, Vector.Element ... elements) {
        if (elements.length != MathHelper.numberOfNoNZeroNonNaNElements(vector)) {
            return false;
        }
        for (Vector.Element element : elements) {
            if (!(Math.abs(element.get() - vector.get(element.index())) > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    public static int numberOfNoNZeroNonNaNElements(Vector vector) {
        int elementsInVector = 0;
        for (Vector.Element currentElement : vector.nonZeroes()) {
            if (Double.isNaN(currentElement.get())) continue;
            ++elementsInVector;
        }
        return elementsInVector;
    }

    public static Matrix readMatrix(Configuration conf, Path path, int rows, int columns) {
        boolean readOneRow = false;
        DenseMatrix matrix = new DenseMatrix(rows, columns);
        for (Pair record : new SequenceFileIterable(path, true, conf)) {
            IntWritable key = (IntWritable)record.getFirst();
            VectorWritable value = (VectorWritable)record.getSecond();
            readOneRow = true;
            int row = key.get();
            for (Vector.Element element : value.get().nonZeroes()) {
                matrix.set(row, element.index(), element.get());
            }
        }
        if (!readOneRow) {
            throw new IllegalStateException("Not a single row read!");
        }
        return matrix;
    }

    public static OpenIntObjectHashMap<Vector> readMatrixRows(Configuration conf, Path path) {
        boolean readOneRow = false;
        OpenIntObjectHashMap rows = new OpenIntObjectHashMap();
        for (Pair record : new SequenceFileIterable(path, true, conf)) {
            IntWritable key = (IntWritable)record.getFirst();
            readOneRow = true;
            rows.put(key.get(), (Object)((VectorWritable)record.getSecond()).get());
        }
        if (!readOneRow) {
            throw new IllegalStateException("Not a single row read!");
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDistributedRowMatrix(double[][] entries, FileSystem fs, Configuration conf, Path path) throws IOException {
        SequenceFile.Writer writer = null;
        try {
            writer = new SequenceFile.Writer(fs, conf, path, IntWritable.class, VectorWritable.class);
            for (int n = 0; n < entries.length; ++n) {
                RandomAccessSparseVector v = new RandomAccessSparseVector(entries[n].length);
                for (int m = 0; m < entries[n].length; ++m) {
                    v.setQuick(m, entries[n][m]);
                }
                writer.append((Writable)new IntWritable(n), (Writable)new VectorWritable((Vector)v));
            }
        }
        catch (Throwable throwable) {
            Closeables.close(writer, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)writer, (boolean)false);
    }

    public static void assertMatrixEquals(Matrix expected, Matrix actual) {
        Assert.assertEquals((long)expected.numRows(), (long)actual.numRows());
        Assert.assertEquals((long)actual.numCols(), (long)actual.numCols());
        for (int row = 0; row < expected.numRows(); ++row) {
            for (int col = 0; col < expected.numCols(); ++col) {
                Assert.assertEquals((String)("Non-matching values in [" + row + ',' + col + ']'), (double)expected.get(row, col), (double)actual.get(row, col), (double)1.0E-6);
            }
        }
    }

    public static String nice(Vector v) {
        if (!v.isSequentialAccess()) {
            v = new DenseVector(v);
        }
        DecimalFormat df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        StringBuilder buffer = new StringBuilder("[");
        String separator = "";
        for (Vector.Element e : v.all()) {
            buffer.append(separator);
            if (Double.isNaN(e.get())) {
                buffer.append("  -  ");
            } else {
                if (e.get() >= 0.0) {
                    buffer.append(' ');
                }
                buffer.append(df.format(e.get()));
            }
            separator = "\t";
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    public static String nice(Matrix matrix) {
        StringBuilder info = new StringBuilder();
        for (int n = 0; n < matrix.numRows(); ++n) {
            info.append(MathHelper.nice(matrix.viewRow(n))).append('\n');
        }
        return info.toString();
    }

    static class ElementToCheck
    implements Vector.Element {
        private final int index;
        private double value;

        ElementToCheck(int index, double value) {
            this.index = index;
            this.value = value;
        }

        public double get() {
            return this.value;
        }

        public int index() {
            return this.index;
        }

        public void set(double value) {
            this.value = value;
        }
    }
}

