/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.decomposer;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.SolverTest;
import org.apache.mahout.math.decomposer.lanczos.LanczosState;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.hadoop.TestDistributedRowMatrix;
import org.apache.mahout.math.hadoop.decomposer.DistributedLanczosSolver;
import org.apache.mahout.math.hadoop.decomposer.HdfsBackedLanczosState;
import org.junit.Before;

@Deprecated
public final class TestDistributedLanczosSolver
extends MahoutTestCase {
    private int counter = 0;
    private DistributedRowMatrix symCorpus;
    private DistributedRowMatrix asymCorpus;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        File symTestData = this.getTestTempDir("symTestData");
        File asymTestData = this.getTestTempDir("asymTestData");
        this.symCorpus = new TestDistributedRowMatrix().randomDistributedMatrix(100, 90, 80, 2, 10.0, true, symTestData.getAbsolutePath());
        this.asymCorpus = new TestDistributedRowMatrix().randomDistributedMatrix(100, 90, 80, 2, 10.0, false, asymTestData.getAbsolutePath());
    }

    private static String suf(boolean symmetric) {
        return symmetric ? "_sym" : "_asym";
    }

    private DistributedRowMatrix getCorpus(boolean symmetric) {
        return symmetric ? this.symCorpus : this.asymCorpus;
    }

    private LanczosState doTestDistributedLanczosSolver(boolean symmetric, int desiredRank, boolean hdfsBackedState) throws IOException {
        LanczosState state;
        DistributedRowMatrix corpus = this.getCorpus(symmetric);
        Configuration conf = this.getConfiguration();
        corpus.setConf(conf);
        DistributedLanczosSolver solver = new DistributedLanczosSolver();
        Vector intitialVector = DistributedLanczosSolver.getInitialVector((VectorIterable)corpus);
        if (hdfsBackedState) {
            HdfsBackedLanczosState hState = new HdfsBackedLanczosState((VectorIterable)corpus, desiredRank, intitialVector, new Path(this.getTestTempDirPath(), "lanczosStateDir" + TestDistributedLanczosSolver.suf(symmetric) + this.counter));
            hState.setConf(conf);
            state = hState;
        } else {
            state = new LanczosState((VectorIterable)corpus, desiredRank, intitialVector);
        }
        solver.solve(state, desiredRank, symmetric);
        SolverTest.assertOrthonormal((LanczosState)state);
        for (int i = 0; i < desiredRank / 2; ++i) {
            SolverTest.assertEigen((int)i, (Vector)state.getRightSingularVector(i), (VectorIterable)corpus, (double)0.1, (boolean)symmetric);
        }
        ++this.counter;
        return state;
    }

    public void doTestResumeIteration(boolean symmetric) throws IOException {
        DistributedRowMatrix corpus = this.getCorpus(symmetric);
        Configuration conf = this.getConfiguration();
        corpus.setConf(conf);
        DistributedLanczosSolver solver = new DistributedLanczosSolver();
        int rank = 10;
        Vector intitialVector = DistributedLanczosSolver.getInitialVector((VectorIterable)corpus);
        HdfsBackedLanczosState state = new HdfsBackedLanczosState((VectorIterable)corpus, rank, intitialVector, new Path(this.getTestTempDirPath(), "lanczosStateDir" + TestDistributedLanczosSolver.suf(symmetric) + this.counter));
        solver.solve((LanczosState)state, rank, symmetric);
        state = new HdfsBackedLanczosState((VectorIterable)corpus, rank *= 2, intitialVector, new Path(this.getTestTempDirPath(), "lanczosStateDir" + TestDistributedLanczosSolver.suf(symmetric) + this.counter));
        solver = new DistributedLanczosSolver();
        solver.solve((LanczosState)state, rank, symmetric);
        LanczosState allAtOnceState = this.doTestDistributedLanczosSolver(symmetric, rank, false);
        for (int i = 0; i < state.getIterationNumber(); ++i) {
            Vector v = state.getBasisVector(i).normalize();
            Vector w = allAtOnceState.getBasisVector(i).normalize();
            double diff = v.minus(w).norm(2.0);
            TestDistributedLanczosSolver.assertTrue((String)("basis " + i + " is too long: " + diff), (diff < 0.1 ? 1 : 0) != 0);
        }
        ++this.counter;
    }
}

