/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.decomposer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.hadoop.TestDistributedRowMatrix;
import org.apache.mahout.math.hadoop.decomposer.DistributedLanczosSolver;
import org.apache.mahout.math.hadoop.decomposer.EigenVector;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class TestDistributedLanczosSolverCLI
extends MahoutTestCase {
    private static final Logger log = LoggerFactory.getLogger(TestDistributedLanczosSolverCLI.class);

    @Test
    public void testDistributedLanczosSolverCLI() throws Exception {
        Path testData = this.getTestTempDirPath("testdata");
        DistributedRowMatrix corpus = new TestDistributedRowMatrix().randomDenseHierarchicalDistributedMatrix(10, 9, false, testData.toString());
        corpus.setConf(this.getConfiguration());
        Path output = this.getTestTempDirPath("output");
        Path tmp = this.getTestTempDirPath("tmp");
        Path workingDir = this.getTestTempDirPath("working");
        String[] args = new String[]{"-i", new Path(testData, "distMatrix").toString(), "-o", output.toString(), "--tempDir", tmp.toString(), "--numRows", "10", "--numCols", "9", "--rank", "6", "--symmetric", "false", "--workingDir", workingDir.toString()};
        ToolRunner.run((Configuration)this.getConfiguration(), (Tool)new DistributedLanczosSolver.DistributedLanczosSolverJob(new DistributedLanczosSolver()), (String[])args);
        output = this.getTestTempDirPath("output2");
        tmp = this.getTestTempDirPath("tmp2");
        args = new String[]{"-i", new Path(testData, "distMatrix").toString(), "-o", output.toString(), "--tempDir", tmp.toString(), "--numRows", "10", "--numCols", "9", "--rank", "7", "--symmetric", "false", "--workingDir", workingDir.toString()};
        ToolRunner.run((Configuration)this.getConfiguration(), (Tool)new DistributedLanczosSolver.DistributedLanczosSolverJob(new DistributedLanczosSolver()), (String[])args);
        Path rawEigenvectors = new Path(output, "rawEigenvectors");
        DenseMatrix eigenVectors = new DenseMatrix(7, corpus.numCols());
        Configuration conf = this.getConfiguration();
        int i = 0;
        for (VectorWritable value : new SequenceFileValueIterable(rawEigenvectors, conf)) {
            Vector v = value.get();
            eigenVectors.assignRow(i, v);
            ++i;
        }
        TestDistributedLanczosSolverCLI.assertEquals((String)"number of eigenvectors", (long)7L, (long)i);
    }

    @Test
    public void testDistributedLanczosSolverEVJCLI() throws Exception {
        Vector oldEigen;
        NamedVector v;
        Path testData = this.getTestTempDirPath("testdata");
        DistributedRowMatrix corpus = new TestDistributedRowMatrix().randomDenseHierarchicalDistributedMatrix(10, 9, false, testData.toString());
        corpus.setConf(this.getConfiguration());
        Path output = this.getTestTempDirPath("output");
        Path tmp = this.getTestTempDirPath("tmp");
        String[] args = new String[]{"-i", new Path(testData, "distMatrix").toString(), "-o", output.toString(), "--tempDir", tmp.toString(), "--numRows", "10", "--numCols", "9", "--rank", "6", "--symmetric", "false", "--cleansvd", "true"};
        ToolRunner.run((Configuration)this.getConfiguration(), (Tool)new DistributedLanczosSolver.DistributedLanczosSolverJob(new DistributedLanczosSolver()), (String[])args);
        Path cleanEigenvectors = new Path(output, "cleanEigenvectors");
        DenseMatrix eigenVectors = new DenseMatrix(6, corpus.numCols());
        ArrayList eigenvalues = Lists.newArrayList();
        output = this.getTestTempDirPath("output2");
        tmp = this.getTestTempDirPath("tmp2");
        args = new String[]{"-i", new Path(testData, "distMatrix").toString(), "-o", output.toString(), "--tempDir", tmp.toString(), "--numRows", "10", "--numCols", "9", "--rank", "7", "--symmetric", "false", "--cleansvd", "true"};
        ToolRunner.run((Configuration)this.getConfiguration(), (Tool)new DistributedLanczosSolver.DistributedLanczosSolverJob(new DistributedLanczosSolver()), (String[])args);
        Path cleanEigenvectors2 = new Path(output, "cleanEigenvectors");
        DenseMatrix eigenVectors2 = new DenseMatrix(7, corpus.numCols());
        Configuration conf = this.getConfiguration();
        ArrayList newEigenValues = Lists.newArrayList();
        int i = 0;
        for (VectorWritable value : new SequenceFileValueIterable(cleanEigenvectors, conf)) {
            v = (NamedVector)value.get();
            eigenVectors.assignRow(i, (Vector)v);
            log.info(v.getName());
            if (EigenVector.getCosAngleError((CharSequence)v.getName()) < 0.001) {
                eigenvalues.add(EigenVector.getEigenValue((CharSequence)v.getName()));
            }
            ++i;
        }
        TestDistributedLanczosSolverCLI.assertEquals((String)"number of clean eigenvectors", (long)3L, (long)i);
        i = 0;
        for (VectorWritable value : new SequenceFileValueIterable(cleanEigenvectors2, conf)) {
            v = (NamedVector)value.get();
            log.info(v.getName());
            eigenVectors2.assignRow(i, (Vector)v);
            newEigenValues.add(EigenVector.getEigenValue((CharSequence)v.getName()));
            ++i;
        }
        ArrayList oldEigensFound = Lists.newArrayList();
        block2: for (int row = 0; row < eigenVectors.numRows() && (oldEigen = eigenVectors.viewRow(row)) != null; ++row) {
            for (int newRow = 0; newRow < eigenVectors2.numRows(); ++newRow) {
                Vector newEigen = eigenVectors2.viewRow(newRow);
                if (newEigen == null || !(oldEigen.dot(newEigen) > 0.9)) continue;
                oldEigensFound.add(row);
                continue block2;
            }
        }
        TestDistributedLanczosSolverCLI.assertEquals((String)"the number of new eigenvectors", (long)5L, (long)i);
        ArrayList oldEigenValuesNotFound = Lists.newArrayList();
        Iterator i$ = eigenvalues.iterator();
        while (i$.hasNext()) {
            double d = (Double)i$.next();
            boolean found = false;
            Iterator i$2 = newEigenValues.iterator();
            while (i$2.hasNext()) {
                double newD = (Double)i$2.next();
                if (!(Math.abs((d - newD) / d) < 0.1)) continue;
                found = true;
            }
            if (found) continue;
            oldEigenValuesNotFound.add(d);
        }
        TestDistributedLanczosSolverCLI.assertEquals((String)("number of old eigenvalues not found: " + Arrays.toString((Object[])oldEigenValuesNotFound.toArray(new Double[oldEigenValuesNotFound.size()]))), (long)0L, (long)oldEigenValuesNotFound.size());
        TestDistributedLanczosSolverCLI.assertEquals((String)"did not find enough old eigenvectors", (long)3L, (long)oldEigensFound.size());
    }
}

