/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.cooccurrence;

import java.io.File;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.hadoop.MathHelper;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.RowSimilarityJob;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.Vectors;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.TanimotoCoefficientSimilarity;
import org.apache.mahout.math.map.OpenIntIntHashMap;
import org.junit.Test;

public class RowSimilarityJobTest
extends MahoutTestCase {
    @Test
    public void toyIntegration() throws Exception {
        File inputFile = this.getTestTempFile("rows");
        File outputDir = this.getTestTempDir("output");
        outputDir.delete();
        File tmpDir = this.getTestTempDir("tmp");
        Configuration conf = this.getConfiguration();
        Path inputPath = new Path(inputFile.getAbsolutePath());
        FileSystem fs = FileSystem.get((URI)inputPath.toUri(), (Configuration)conf);
        MathHelper.writeDistributedRowMatrix(new double[][]{{1.0, 0.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}}, fs, conf, inputPath);
        RowSimilarityJob rowSimilarityJob = new RowSimilarityJob();
        rowSimilarityJob.setConf(conf);
        rowSimilarityJob.run(new String[]{"--input", inputFile.getAbsolutePath(), "--output", outputDir.getAbsolutePath(), "--numberOfColumns", String.valueOf(5), "--similarityClassname", TanimotoCoefficientSimilarity.class.getName(), "--tempDir", tmpDir.getAbsolutePath()});
        OpenIntIntHashMap observationsPerColumn = Vectors.readAsIntMap((Path)new Path(tmpDir.getAbsolutePath(), "observationsPerColumn.bin"), (Configuration)conf);
        RowSimilarityJobTest.assertEquals((long)4L, (long)observationsPerColumn.size());
        RowSimilarityJobTest.assertEquals((long)1L, (long)observationsPerColumn.get(0));
        RowSimilarityJobTest.assertEquals((long)2L, (long)observationsPerColumn.get(2));
        RowSimilarityJobTest.assertEquals((long)2L, (long)observationsPerColumn.get(3));
        RowSimilarityJobTest.assertEquals((long)1L, (long)observationsPerColumn.get(4));
        Matrix similarityMatrix = MathHelper.readMatrix(conf, new Path(outputDir.getAbsolutePath(), "part-r-00000"), 3, 3);
        RowSimilarityJobTest.assertNotNull((Object)similarityMatrix);
        RowSimilarityJobTest.assertEquals((long)3L, (long)similarityMatrix.numCols());
        RowSimilarityJobTest.assertEquals((long)3L, (long)similarityMatrix.numRows());
        RowSimilarityJobTest.assertEquals((double)1.0, (double)similarityMatrix.get(0, 0), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)1.0, (double)similarityMatrix.get(1, 1), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)1.0, (double)similarityMatrix.get(2, 2), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(2, 0), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(2, 1), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(0, 2), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(1, 2), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.666666, (double)similarityMatrix.get(0, 1), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.666666, (double)similarityMatrix.get(1, 0), (double)1.0E-6);
    }

    @Test
    public void toyIntegrationMaxSimilaritiesPerRow() throws Exception {
        File inputFile = this.getTestTempFile("rows");
        File outputDir = this.getTestTempDir("output");
        outputDir.delete();
        File tmpDir = this.getTestTempDir("tmp");
        Configuration conf = this.getConfiguration();
        Path inputPath = new Path(inputFile.getAbsolutePath());
        FileSystem fs = FileSystem.get((URI)inputPath.toUri(), (Configuration)conf);
        MathHelper.writeDistributedRowMatrix(new double[][]{{1.0, 0.0, 1.0, 1.0, 0.0, 1.0}, {0.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 0.0, 1.0, 0.0, 0.0}}, fs, conf, inputPath);
        RowSimilarityJob rowSimilarityJob = new RowSimilarityJob();
        rowSimilarityJob.setConf(conf);
        rowSimilarityJob.run(new String[]{"--input", inputFile.getAbsolutePath(), "--output", outputDir.getAbsolutePath(), "--numberOfColumns", String.valueOf(6), "--similarityClassname", TanimotoCoefficientSimilarity.class.getName(), "--maxSimilaritiesPerRow", String.valueOf(1), "--excludeSelfSimilarity", String.valueOf(true), "--tempDir", tmpDir.getAbsolutePath()});
        Matrix similarityMatrix = MathHelper.readMatrix(conf, new Path(outputDir.getAbsolutePath(), "part-r-00000"), 3, 3);
        RowSimilarityJobTest.assertNotNull((Object)similarityMatrix);
        RowSimilarityJobTest.assertEquals((long)3L, (long)similarityMatrix.numCols());
        RowSimilarityJobTest.assertEquals((long)3L, (long)similarityMatrix.numRows());
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(0, 0), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.5, (double)similarityMatrix.get(0, 1), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(0, 2), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.5, (double)similarityMatrix.get(1, 0), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(1, 1), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(1, 2), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.4, (double)similarityMatrix.get(2, 0), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(2, 1), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(2, 2), (double)1.0E-6);
    }

    @Test
    public void toyIntegrationWithThreshold() throws Exception {
        File inputFile = this.getTestTempFile("rows");
        File outputDir = this.getTestTempDir("output");
        outputDir.delete();
        File tmpDir = this.getTestTempDir("tmp");
        Configuration conf = this.getConfiguration();
        Path inputPath = new Path(inputFile.getAbsolutePath());
        FileSystem fs = FileSystem.get((URI)inputPath.toUri(), (Configuration)conf);
        MathHelper.writeDistributedRowMatrix(new double[][]{{1.0, 0.0, 1.0, 1.0, 0.0, 1.0}, {0.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 0.0, 1.0, 0.0, 0.0}}, fs, conf, inputPath);
        RowSimilarityJob rowSimilarityJob = new RowSimilarityJob();
        rowSimilarityJob.setConf(conf);
        rowSimilarityJob.run(new String[]{"--input", inputFile.getAbsolutePath(), "--output", outputDir.getAbsolutePath(), "--numberOfColumns", String.valueOf(6), "--similarityClassname", TanimotoCoefficientSimilarity.class.getName(), "--excludeSelfSimilarity", String.valueOf(true), "--threshold", String.valueOf(0.5), "--tempDir", tmpDir.getAbsolutePath()});
        Matrix similarityMatrix = MathHelper.readMatrix(conf, new Path(outputDir.getAbsolutePath(), "part-r-00000"), 3, 3);
        RowSimilarityJobTest.assertNotNull((Object)similarityMatrix);
        RowSimilarityJobTest.assertEquals((long)3L, (long)similarityMatrix.numCols());
        RowSimilarityJobTest.assertEquals((long)3L, (long)similarityMatrix.numRows());
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(0, 0), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.5, (double)similarityMatrix.get(0, 1), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(0, 2), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.5, (double)similarityMatrix.get(1, 0), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(1, 1), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(1, 2), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(2, 0), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(2, 1), (double)1.0E-6);
        RowSimilarityJobTest.assertEquals((double)0.0, (double)similarityMatrix.get(2, 2), (double)1.0E-6);
    }

    @Test
    public void testVectorDimensions() throws Exception {
        File inputFile = this.getTestTempFile("rows");
        Configuration conf = this.getConfiguration();
        Path inputPath = new Path(inputFile.getAbsolutePath());
        FileSystem fs = FileSystem.get((URI)inputPath.toUri(), (Configuration)conf);
        MathHelper.writeDistributedRowMatrix(new double[][]{{1.0, 0.0, 1.0, 1.0, 0.0, 1.0}, {0.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 0.0, 1.0, 0.0, 0.0}}, fs, conf, inputPath);
        RowSimilarityJob rowSimilarityJob = new RowSimilarityJob();
        rowSimilarityJob.setConf(conf);
        int numberOfColumns = rowSimilarityJob.getDimensions(inputPath);
        RowSimilarityJobTest.assertEquals((long)6L, (long)numberOfColumns);
    }
}

