/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stats;

import java.net.URI;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.hadoop.stats.BasicStats;
import org.apache.mahout.math.jet.random.Normal;
import org.junit.Before;
import org.junit.Test;

public final class BasicStatsTest
extends MahoutTestCase {
    private Configuration conf;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf = this.getConfiguration();
    }

    @Test
    public void testVar() throws Exception {
        Path input = this.getTestTempFilePath("stdDev/counts.file");
        Path output = this.getTestTempFilePath("stdDev/output.file");
        this.produceTestData(input);
        double v = BasicStats.variance((Path)input, (Path)output, (Configuration)this.conf);
        BasicStatsTest.assertEquals((double)2.44, (double)v, (double)0.01);
    }

    @Test
    public void testStdDev() throws Exception {
        Path input = this.getTestTempFilePath("stdDev/counts.file");
        Path output = this.getTestTempFilePath("stdDev/output.file");
        this.produceTestData(input);
        double v = BasicStats.stdDev((Path)input, (Path)output, (Configuration)this.conf);
        BasicStatsTest.assertEquals((double)1.56, (double)v, (double)0.01);
    }

    @Test
    public void testStdDevForGivenMean() throws Exception {
        Path input = this.getTestTempFilePath("stdDev/counts.file");
        Path output = this.getTestTempFilePath("stdDev/output.file");
        this.produceTestData(input);
        double v = BasicStats.stdDevForGivenMean((Path)input, (Path)output, (double)0.0, (Configuration)this.conf);
        BasicStatsTest.assertEquals((double)10.65, (double)v, (double)0.01);
    }

    private void produceTestData(Path input) throws Exception {
        FileSystem fs = FileSystem.get((URI)input.toUri(), (Configuration)this.conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, this.conf, input, IntWritable.class, DoubleWritable.class);
        int i = 0;
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(7.0));
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(9.0));
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(9.0));
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(10.0));
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(10.0));
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(10.0));
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(10.0));
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(11.0));
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(11.0));
        writer.append((Writable)new IntWritable(i++), (Writable)new DoubleWritable(13.0));
        writer.close();
    }

    @Test
    public void testStdDev2() throws Exception {
        Path input = this.getTestTempFilePath("stdDev/counts.file");
        Path output = this.getTestTempFilePath("stdDev/output.file");
        FileSystem fs = FileSystem.get((URI)input.toUri(), (Configuration)this.conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, this.conf, input, IntWritable.class, DoubleWritable.class);
        RandomWrapper random = RandomUtils.getRandom();
        Normal normal = new Normal(5.0, 3.0, (Random)random);
        for (int i = 0; i < 1000000; ++i) {
            writer.append((Writable)new IntWritable(i), (Writable)new DoubleWritable((double)normal.nextInt()));
        }
        writer.close();
        double v = BasicStats.stdDev((Path)input, (Path)output, (Configuration)this.conf);
        BasicStatsTest.assertEquals((double)3.0, (double)v, (double)0.02);
    }
}

