/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDCommonTest;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDHelper;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDTestsHelper;
import org.junit.Test;

public class LocalSSVDSolverDenseTest
extends MahoutTestCase {
    private static final double s_epsilon = 1.0E-10;
    private static final double s_precisionPct = 10.0;

    @Test
    public void testSSVDSolverDense() throws IOException {
        this.runSSVDSolver(0);
    }

    @Test
    public void testSSVDSolverPowerIterations1() throws IOException {
        this.runSSVDSolver(1);
    }

    public void runSSVDSolver(int q) throws IOException {
        Configuration conf = this.getConfiguration();
        conf.set("mapred.job.tracker", "local");
        conf.set("fs.default.name", "file:///");
        File tmpDir = this.getTestTempDir("svdtmp");
        conf.set("hadoop.tmp.dir", tmpDir.getAbsolutePath());
        Path aLocPath = new Path(this.getTestTempDirPath("svdtmp/A"), "A.seq");
        int n = 100;
        int m = 2000;
        DenseVector singularValues = new DenseVector(new double[]{10.0, 4.0, 1.0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1});
        SSVDTestsHelper.generateDenseInput(aLocPath, (FileSystem)FileSystem.getLocal((Configuration)conf), (Vector)singularValues, m, n);
        FileSystem fs = FileSystem.get((URI)aLocPath.toUri(), (Configuration)conf);
        Path tempDirPath = this.getTestTempDirPath("svd-proc");
        Path aPath = new Path(tempDirPath, "A/A.seq");
        fs.copyFromLocalFile(aLocPath, aPath);
        Path svdOutPath = new Path(tempDirPath, "SSVD-out");
        System.out.println("Input prepared, starting solver...");
        int ablockRows = 867;
        int p = 10;
        int k = 3;
        SSVDSolver ssvd = new SSVDSolver(conf, new Path[]{aPath}, svdOutPath, ablockRows, k, p, 3);
        ssvd.setOuterBlockHeight(500);
        ssvd.setAbtBlockHeight(400);
        ssvd.setOverwrite(true);
        ssvd.setQ(q);
        ssvd.setBroadcast(false);
        ssvd.run();
        Vector stochasticSValues = ssvd.getSingularValues();
        System.out.println("--SSVD solver singular values:");
        LocalSSVDSolverDenseTest.dumpSv(stochasticSValues);
        for (int i = 0; i < k; ++i) {
            LocalSSVDSolverDenseTest.assertTrue((Math.abs((singularValues.getQuick(i) - stochasticSValues.getQuick(i)) / singularValues.getQuick(i)) <= 0.1 ? 1 : 0) != 0);
        }
        DenseMatrix mQ = SSVDHelper.drmLoadAsDense((FileSystem)fs, (Path)new Path(svdOutPath, "Bt-job/Q-*"), (Configuration)conf);
        SSVDCommonTest.assertOrthonormality((Matrix)mQ, false, 1.0E-10);
        DenseMatrix u = SSVDHelper.drmLoadAsDense((FileSystem)fs, (Path)new Path(svdOutPath, "U/*"), (Configuration)conf);
        SSVDCommonTest.assertOrthonormality((Matrix)u, false, 1.0E-10);
        DenseMatrix v = SSVDHelper.drmLoadAsDense((FileSystem)fs, (Path)new Path(svdOutPath, "V/*"), (Configuration)conf);
        SSVDCommonTest.assertOrthonormality((Matrix)v, false, 1.0E-10);
    }

    static void dumpSv(Vector s) {
        System.out.printf("svs: ", new Object[0]);
        for (Vector.Element el : s.all()) {
            System.out.printf("%f  ", el.get());
        }
        System.out.println();
    }
}

