/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.neighborhood;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.random.ChineseRestaurant;
import org.apache.mahout.math.random.MultiNormal;
import org.apache.mahout.math.random.Sampler;

public class LumpyData
implements Sampler<Vector> {
    private final double radius;
    private final Sampler<Integer> cluster;
    private final List<Sampler<Vector>> centroids = Lists.newArrayList();
    private final MultiNormal centers;

    public LumpyData(int dimension, double radius, double alpha) {
        this.centers = new MultiNormal(dimension);
        this.radius = radius;
        this.cluster = new ChineseRestaurant(alpha);
    }

    public static Matrix lumpyRandomData(int numDataPoints, int numDimensions) {
        DenseMatrix data = new DenseMatrix(numDataPoints, numDimensions);
        LumpyData clusters = new LumpyData(numDimensions, 0.05, 10.0);
        for (MatrixSlice row : data) {
            row.vector().assign(clusters.sample());
        }
        return data;
    }

    public Vector sample() {
        int id = (Integer)this.cluster.sample();
        if (id >= this.centroids.size()) {
            this.centroids.add((Sampler<Vector>)new MultiNormal(this.radius, this.centers.sample()));
        }
        return (Vector)this.centroids.get(id).sample();
    }
}

