/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import org.apache.mahout.classifier.evaluation.Auc;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.stats.GlobalOnlineAuc;
import org.apache.mahout.math.stats.GroupedOnlineAuc;
import org.apache.mahout.math.stats.OnlineSummarizer;
import org.junit.Test;

public final class OnlineAucTest
extends MahoutTestCase {
    @Test
    public void testBinaryCase() {
        int i;
        RandomWrapper gen = RandomUtils.getRandom();
        OnlineSummarizer[] stats = new OnlineSummarizer[4];
        for (i = 0; i < 4; ++i) {
            stats[i] = new OnlineSummarizer();
        }
        for (i = 0; i < 100; ++i) {
            GlobalOnlineAuc a1 = new GlobalOnlineAuc();
            a1.setPolicy(GlobalOnlineAuc.ReplacementPolicy.FAIR);
            GlobalOnlineAuc a2 = new GlobalOnlineAuc();
            a2.setPolicy(GlobalOnlineAuc.ReplacementPolicy.FIFO);
            GlobalOnlineAuc a3 = new GlobalOnlineAuc();
            a3.setPolicy(GlobalOnlineAuc.ReplacementPolicy.RANDOM);
            Auc a4 = new Auc();
            for (int j = 0; j < 10000; ++j) {
                double x = gen.nextGaussian();
                a1.addSample(0, x);
                a2.addSample(0, x);
                a3.addSample(0, x);
                a4.add(0, x);
                x = gen.nextGaussian() + 1.0;
                a1.addSample(1, x);
                a2.addSample(1, x);
                a3.addSample(1, x);
                a4.add(1, x);
            }
            stats[0].add(a1.auc());
            stats[1].add(a2.auc());
            stats[2].add(a3.auc());
            stats[3].add(a4.auc());
        }
        i = 0;
        for (GlobalOnlineAuc.ReplacementPolicy policy : new GlobalOnlineAuc.ReplacementPolicy[]{GlobalOnlineAuc.ReplacementPolicy.FAIR, GlobalOnlineAuc.ReplacementPolicy.FIFO, GlobalOnlineAuc.ReplacementPolicy.RANDOM, null}) {
            OnlineSummarizer summary = stats[i++];
            System.out.printf("%s,%.4f (min = %.4f, 25%%-ile=%.4f, 75%%-ile=%.4f, max=%.4f)\n", policy, summary.getMean(), summary.getQuartile(0), summary.getQuartile(1), summary.getQuartile(2), summary.getQuartile(3));
        }
        OnlineAucTest.assertEquals((double)0.7603, (double)stats[0].getMean(), (double)0.03);
        OnlineAucTest.assertEquals((double)0.7603, (double)stats[0].getQuartile(1), (double)0.03);
        OnlineAucTest.assertEquals((double)0.7603, (double)stats[0].getQuartile(3), (double)0.03);
        OnlineAucTest.assertEquals((double)0.7603, (double)stats[1].getMean(), (double)0.001);
        OnlineAucTest.assertEquals((double)0.7603, (double)stats[1].getQuartile(1), (double)0.006);
        OnlineAucTest.assertEquals((double)0.7603, (double)stats[1].getQuartile(3), (double)0.006);
        OnlineAucTest.assertEquals((double)0.7603, (double)stats[2].getMean(), (double)0.001);
        OnlineAucTest.assertEquals((double)0.7603, (double)stats[2].getQuartile(1), (double)0.006);
        OnlineAucTest.assertEquals((double)0.7603, (double)stats[2].getQuartile(1), (double)0.006);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void mustNotOmitGroup() {
        GroupedOnlineAuc x = new GroupedOnlineAuc();
        x.addSample(0, 3.14);
    }

    @Test
    public void groupedAuc() {
        RandomWrapper gen = RandomUtils.getRandom();
        GroupedOnlineAuc x = new GroupedOnlineAuc();
        GlobalOnlineAuc y = new GlobalOnlineAuc();
        for (int i = 0; i < 10000; ++i) {
            x.addSample(0, "a", gen.nextGaussian());
            x.addSample(1, "a", gen.nextGaussian() + 1.0);
            x.addSample(0, "b", gen.nextGaussian() + 10.0);
            x.addSample(1, "b", gen.nextGaussian() + 11.0);
            y.addSample(0, "a", gen.nextGaussian());
            y.addSample(1, "a", gen.nextGaussian() + 1.0);
            y.addSample(0, "b", gen.nextGaussian() + 10.0);
            y.addSample(1, "b", gen.nextGaussian() + 11.0);
        }
        OnlineAucTest.assertEquals((double)0.7603, (double)x.auc(), (double)0.01);
        OnlineAucTest.assertEquals((double)0.63015, (double)y.auc(), (double)0.02);
    }
}

