/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.stats.LogLikelihood;
import org.apache.mahout.vectorizer.collocations.llr.Gram;
import org.apache.mahout.vectorizer.collocations.llr.LLRReducer;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LLRReducerTest
extends MahoutTestCase {
    private static final Logger log = LoggerFactory.getLogger(LLRReducerTest.class);
    private Reducer.Context context;
    private LLRReducer.LLCallback ll;
    private LLRReducer.LLCallback cl;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        this.ll = (LLRReducer.LLCallback)EasyMock.createMock(LLRReducer.LLCallback.class);
        this.cl = new LLRReducer.LLCallback(){

            public double logLikelihoodRatio(long k11, long k12, long k21, long k22) {
                log.info("k11:{} k12:{} k21:{} k22:{}", new Object[]{k11, k12, k21, k22});
                return LogLikelihood.logLikelihoodRatio((long)k11, (long)k12, (long)k21, (long)k22);
            }
        };
    }

    @Test
    public void testReduce() throws Exception {
        LLRReducer reducer = new LLRReducer(this.ll);
        Gram[][] input = new Gram[][]{{new Gram("the best", 1, Gram.Type.NGRAM), new Gram("the", 2, Gram.Type.HEAD), new Gram("best", 1, Gram.Type.TAIL)}, {new Gram("best of", 1, Gram.Type.NGRAM), new Gram("best", 1, Gram.Type.HEAD), new Gram("of", 2, Gram.Type.TAIL)}, {new Gram("of times", 2, Gram.Type.NGRAM), new Gram("of", 2, Gram.Type.HEAD), new Gram("times", 2, Gram.Type.TAIL)}, {new Gram("times the", 1, Gram.Type.NGRAM), new Gram("times", 1, Gram.Type.HEAD), new Gram("the", 1, Gram.Type.TAIL)}, {new Gram("the worst", 1, Gram.Type.NGRAM), new Gram("the", 2, Gram.Type.HEAD), new Gram("worst", 1, Gram.Type.TAIL)}, {new Gram("worst of", 1, Gram.Type.NGRAM), new Gram("worst", 1, Gram.Type.HEAD), new Gram("of", 2, Gram.Type.TAIL)}};
        int[][] expectations = new int[][]{{1, 1, 0, 5}, {1, 0, 1, 5}, {2, 0, 0, 5}, {1, 0, 0, 6}, {1, 1, 0, 5}, {1, 0, 1, 5}};
        Configuration config = this.getConfiguration();
        config.set("ngramTotal", "7");
        EasyMock.expect((Object)this.context.getConfiguration()).andReturn((Object)config);
        for (int i = 0; i < expectations.length; ++i) {
            int[] ee = expectations[i];
            this.context.write(EasyMock.eq((Object)new Text(input[i][0].getString())), (Object)((DoubleWritable)EasyMock.anyObject()));
            EasyMock.expect((Object)this.ll.logLikelihoodRatio((long)ee[0], (long)ee[1], (long)ee[2], (long)ee[3])).andDelegateTo((Object)this.cl);
        }
        EasyMock.replay((Object[])new Object[]{this.context, this.ll});
        reducer.setup(this.context);
        for (Gram[] ii : input) {
            LinkedList vv = Lists.newLinkedList();
            vv.addAll(Arrays.asList(ii).subList(1, ii.length));
            reducer.reduce(ii[0], (Iterable)vv, this.context);
        }
        EasyMock.verify((Object[])new Object[]{this.ll});
    }
}

