/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.als.ALS;
import org.apache.mahout.cf.taste.hadoop.als.ParallelALSFactorizationJob;
import org.apache.mahout.cf.taste.hadoop.als.SharingMapper;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenIntObjectHashMap;

public class SolveExplicitFeedbackMapper
extends SharingMapper<IntWritable, VectorWritable, IntWritable, VectorWritable, OpenIntObjectHashMap<Vector>> {
    private double lambda;
    private int numFeatures;
    private final VectorWritable uiOrmj = new VectorWritable();

    @Override
    OpenIntObjectHashMap<Vector> createSharedInstance(Mapper.Context ctx) throws IOException {
        Configuration conf = ctx.getConfiguration();
        int numEntities = Integer.parseInt(conf.get(ParallelALSFactorizationJob.NUM_ENTITIES));
        return ALS.readMatrixByRowsFromDistributedCache(numEntities, conf);
    }

    protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
        this.lambda = Double.parseDouble(ctx.getConfiguration().get(ParallelALSFactorizationJob.LAMBDA));
        this.numFeatures = ctx.getConfiguration().getInt(ParallelALSFactorizationJob.NUM_FEATURES, -1);
        Preconditions.checkArgument((this.numFeatures > 0 ? 1 : 0) != 0, (Object)"numFeatures must be greater then 0!");
    }

    protected void map(IntWritable userOrItemID, VectorWritable ratingsWritable, Mapper.Context ctx) throws IOException, InterruptedException {
        OpenIntObjectHashMap uOrM = (OpenIntObjectHashMap)this.getSharedInstance();
        this.uiOrmj.set(ALS.solveExplicit(ratingsWritable, (OpenIntObjectHashMap<Vector>)uOrM, this.lambda, this.numFeatures));
        ctx.write((Object)userOrItemID, (Object)this.uiOrmj);
    }
}

