/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import java.io.Serializable;
import java.util.Arrays;

final class BitSet
implements Serializable,
Cloneable {
    private final long[] bits;

    BitSet(int numBits) {
        int numLongs = numBits >>> 6;
        if ((numBits & 0x3F) != 0) {
            ++numLongs;
        }
        this.bits = new long[numLongs];
    }

    private BitSet(long[] bits) {
        this.bits = bits;
    }

    boolean get(int index) {
        return (this.bits[index >>> 6] & 1L << (index & 0x3F)) != 0L;
    }

    void set(int index) {
        int n = index >>> 6;
        this.bits[n] = this.bits[n] | 1L << (index & 0x3F);
    }

    void clear(int index) {
        int n = index >>> 6;
        this.bits[n] = this.bits[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    void clear() {
        int length = this.bits.length;
        for (int i = 0; i < length; ++i) {
            this.bits[i] = 0L;
        }
    }

    public BitSet clone() {
        return new BitSet((long[])this.bits.clone());
    }

    public int hashCode() {
        return Arrays.hashCode(this.bits);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitSet)) {
            return false;
        }
        BitSet other = (BitSet)o;
        return Arrays.equals(this.bits, other.bits);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(64 * this.bits.length);
        for (long l : this.bits) {
            for (int j = 0; j < 64; ++j) {
                result.append((l & 1L << j) == 0L ? (char)'0' : '1');
            }
            result.append(' ');
        }
        return result.toString();
    }
}

