/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.iterator.CountingIterator;

public final class BooleanUserPreferenceArray
implements PreferenceArray {
    private final long[] ids;
    private long id;

    public BooleanUserPreferenceArray(int size) {
        this.ids = new long[size];
        this.id = Long.MIN_VALUE;
    }

    public BooleanUserPreferenceArray(List<? extends Preference> prefs) {
        this(prefs.size());
        int size = prefs.size();
        for (int i = 0; i < size; ++i) {
            Preference pref = prefs.get(i);
            this.ids[i] = pref.getItemID();
        }
        if (size > 0) {
            this.id = prefs.get(0).getUserID();
        }
    }

    private BooleanUserPreferenceArray(long[] ids, long id) {
        this.ids = ids;
        this.id = id;
    }

    @Override
    public int length() {
        return this.ids.length;
    }

    @Override
    public Preference get(int i) {
        return new PreferenceView(i);
    }

    @Override
    public void set(int i, Preference pref) {
        this.id = pref.getUserID();
        this.ids[i] = pref.getItemID();
    }

    @Override
    public long getUserID(int i) {
        return this.id;
    }

    @Override
    public void setUserID(int i, long userID) {
        this.id = userID;
    }

    @Override
    public long getItemID(int i) {
        return this.ids[i];
    }

    @Override
    public void setItemID(int i, long itemID) {
        this.ids[i] = itemID;
    }

    @Override
    public long[] getIDs() {
        return this.ids;
    }

    @Override
    public float getValue(int i) {
        return 1.0f;
    }

    @Override
    public void setValue(int i, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sortByUser() {
    }

    @Override
    public void sortByItem() {
        Arrays.sort(this.ids);
    }

    @Override
    public void sortByValue() {
    }

    @Override
    public void sortByValueReversed() {
    }

    @Override
    public boolean hasPrefWithUserID(long userID) {
        return this.id == userID;
    }

    @Override
    public boolean hasPrefWithItemID(long itemID) {
        for (long id : this.ids) {
            if (itemID != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public BooleanUserPreferenceArray clone() {
        return new BooleanUserPreferenceArray((long[])this.ids.clone(), this.id);
    }

    public int hashCode() {
        return (int)(this.id >> 32) ^ (int)this.id ^ Arrays.hashCode(this.ids);
    }

    public boolean equals(Object other) {
        if (!(other instanceof BooleanUserPreferenceArray)) {
            return false;
        }
        BooleanUserPreferenceArray otherArray = (BooleanUserPreferenceArray)other;
        return this.id == otherArray.id && Arrays.equals(this.ids, otherArray.ids);
    }

    @Override
    public Iterator<Preference> iterator() {
        return Iterators.transform((Iterator)((Object)new CountingIterator(this.length())), (Function)new Function<Integer, Preference>(){

            public Preference apply(Integer from) {
                return new PreferenceView(from);
            }
        });
    }

    public String toString() {
        StringBuilder result = new StringBuilder(10 * this.ids.length);
        result.append("BooleanUserPreferenceArray[userID:");
        result.append(this.id);
        result.append(",{");
        for (int i = 0; i < this.ids.length; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.ids[i]);
        }
        result.append("}]");
        return result.toString();
    }

    private final class PreferenceView
    implements Preference {
        private final int i;

        private PreferenceView(int i) {
            this.i = i;
        }

        @Override
        public long getUserID() {
            return BooleanUserPreferenceArray.this.getUserID(this.i);
        }

        @Override
        public long getItemID() {
            return BooleanUserPreferenceArray.this.getItemID(this.i);
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public void setValue(float value) {
            throw new UnsupportedOperationException();
        }
    }
}

