/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.ssvd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.mahout.math.CholeskyDecomposition;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;
import org.apache.mahout.math.RandomTrinaryMatrix;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class SequentialOutOfCoreSvd {
    private final CholeskyDecomposition l2;
    private final SingularValueDecomposition svd;
    private final CholeskyDecomposition r2;
    private final int columnsPerSlice;
    private final int seed;
    private final int dim;

    public SequentialOutOfCoreSvd(Iterable<File> partsOfA, File tmpDir, int internalDimension, int columnsPerSlice) throws IOException {
        DataInputStream in;
        Throwable y;
        this.columnsPerSlice = columnsPerSlice;
        this.dim = internalDimension;
        this.seed = 1;
        Matrix y2 = null;
        for (File file : partsOfA) {
            MatrixWritable m = new MatrixWritable();
            try (DataInputStream in2 = new DataInputStream(new FileInputStream(file));){
                m.readFields(in2);
            }
            Matrix aI = m.get();
            RandomTrinaryMatrix omega = new RandomTrinaryMatrix(this.seed, aI.columnSize(), internalDimension, false);
            y = aI.times((Matrix)omega);
            if (y2 == null) {
                y2 = y.transpose().times((Matrix)y);
                continue;
            }
            y2.assign(y.transpose().times((Matrix)y), Functions.PLUS);
        }
        this.r2 = new CholeskyDecomposition(y2);
        int ncols = 0;
        for (File file : partsOfA) {
            MatrixWritable m = new MatrixWritable();
            in = new DataInputStream(new FileInputStream(file));
            y = null;
            try {
                m.readFields(in);
            }
            catch (Throwable x2) {
                y = x2;
                throw x2;
            }
            finally {
                if (in != null) {
                    if (y != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable x2) {
                            y.addSuppressed(x2);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            Matrix aI = m.get();
            ncols = Math.max(ncols, aI.columnSize());
            RandomTrinaryMatrix omega = new RandomTrinaryMatrix(this.seed, aI.numCols(), internalDimension, false);
            for (int j = 0; j < aI.numCols(); j += columnsPerSlice) {
                Matrix yI = aI.times((Matrix)omega);
                Matrix aIJ = aI.viewPart(0, aI.rowSize(), j, Math.min(columnsPerSlice, aI.columnSize() - j));
                Matrix bIJ = this.r2.solveRight(yI).transpose().times(aIJ);
                SequentialOutOfCoreSvd.addToSavedCopy(SequentialOutOfCoreSvd.bFile(tmpDir, j), bIJ);
            }
        }
        DenseMatrix b2 = new DenseMatrix(internalDimension, internalDimension);
        MatrixWritable bTmp = new MatrixWritable();
        for (int j = 0; j < ncols; j += columnsPerSlice) {
            if (!SequentialOutOfCoreSvd.bFile(tmpDir, j).exists()) continue;
            in = new DataInputStream(new FileInputStream(SequentialOutOfCoreSvd.bFile(tmpDir, j)));
            Throwable throwable = null;
            try {
                bTmp.readFields(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            b2.assign(bTmp.get().times(bTmp.get().transpose()), Functions.PLUS);
        }
        this.l2 = new CholeskyDecomposition((Matrix)b2);
        this.svd = new SingularValueDecomposition(this.l2.getL());
    }

    public void computeV(File tmpDir, int ncols) throws IOException {
        for (int j = 0; j < ncols; j += this.columnsPerSlice) {
            File bPath = SequentialOutOfCoreSvd.bFile(tmpDir, j);
            if (!bPath.exists()) continue;
            MatrixWritable m = new MatrixWritable();
            try (DataInputStream in = new DataInputStream(new FileInputStream(bPath));){
                m.readFields(in);
            }
            m.set(this.l2.solveRight(m.get().transpose()).times(this.svd.getV()));
            var7_7 = null;
            try (DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(tmpDir, String.format("V-%s", bPath.getName().replaceAll(".*-", "")))));){
                m.write(out);
                continue;
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
        }
    }

    public void computeU(Iterable<File> partsOfA, File tmpDir) throws IOException {
        for (File file : partsOfA) {
            MatrixWritable m = new MatrixWritable();
            m.readFields(new DataInputStream(new FileInputStream(file)));
            Matrix aI = m.get();
            Matrix y = aI.times((Matrix)new RandomTrinaryMatrix(this.seed, aI.numCols(), this.dim, false));
            Matrix uI = this.r2.solveRight(y).times(this.svd.getU());
            m.set(uI);
            DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(tmpDir, String.format("U-%s", file.getName().replaceAll(".*-", "")))));
            Throwable throwable = null;
            try {
                m.write(out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private static void addToSavedCopy(File file, Matrix matrix) throws IOException {
        Throwable throwable;
        MatrixWritable mw = new MatrixWritable();
        if (file.exists()) {
            throwable = null;
            try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
                mw.readFields(in);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            mw.get().assign(matrix, Functions.PLUS);
        } else {
            mw.set(matrix);
        }
        throwable = null;
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(file));){
            mw.write(out);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private static File bFile(File tmpDir, int j) {
        return new File(tmpDir, String.format("B-%09d", j));
    }

    public Vector getSingularValues() {
        return new DenseVector(this.svd.getSingularValues());
    }
}

