/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.sgd.PolymorphicWritable;
import org.apache.mahout.math.stats.GlobalOnlineAuc;
import org.apache.mahout.math.stats.OnlineAuc;

public class GroupedOnlineAuc
implements OnlineAuc {
    private final Map<String, OnlineAuc> map = Maps.newHashMap();
    private GlobalOnlineAuc.ReplacementPolicy policy;
    private int windowSize;

    @Override
    public double addSample(int category, String groupKey, double score) {
        OnlineAuc group;
        if (groupKey == null) {
            this.addSample(category, score);
        }
        if ((group = this.map.get(groupKey)) == null) {
            group = new GlobalOnlineAuc();
            if (this.policy != null) {
                group.setPolicy(this.policy);
            }
            if (this.windowSize > 0) {
                group.setWindowSize(this.windowSize);
            }
            this.map.put(groupKey, group);
        }
        return group.addSample(category, score);
    }

    @Override
    public double addSample(int category, double score) {
        throw new UnsupportedOperationException("Can't add to " + this.getClass() + " without group key");
    }

    @Override
    public double auc() {
        double sum = 0.0;
        for (OnlineAuc auc : this.map.values()) {
            sum += auc.auc();
        }
        return sum / (double)this.map.size();
    }

    @Override
    public void setPolicy(GlobalOnlineAuc.ReplacementPolicy policy) {
        this.policy = policy;
        for (OnlineAuc auc : this.map.values()) {
            auc.setPolicy(policy);
        }
    }

    @Override
    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        for (OnlineAuc auc : this.map.values()) {
            auc.setWindowSize(windowSize);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry<String, OnlineAuc> entry : this.map.entrySet()) {
            out.writeUTF(entry.getKey());
            PolymorphicWritable.write(out, (Writable)entry.getValue());
        }
        out.writeInt(this.policy.ordinal());
        out.writeInt(this.windowSize);
    }

    public void readFields(DataInput in) throws IOException {
        int n = in.readInt();
        this.map.clear();
        for (int i = 0; i < n; ++i) {
            String key = in.readUTF();
            this.map.put(key, PolymorphicWritable.read(in, OnlineAuc.class));
        }
        this.policy = GlobalOnlineAuc.ReplacementPolicy.values()[in.readInt()];
        this.windowSize = in.readInt();
    }
}

