/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.doxia.logging.Log;

public class SystemStreamLog
implements Log {
    private static final String EOL = System.getProperty("line.separator");
    private int currentLevel = 1;

    @Override
    public void setLogLevel(int level) {
        this.currentLevel = level <= 0 ? 0 : (level <= 1 ? 1 : (level <= 2 ? 2 : (level <= 3 ? 3 : 5)));
    }

    @Override
    public void debug(CharSequence content) {
        if (this.isDebugEnabled()) {
            this.print("debug", content);
        }
    }

    @Override
    public void debug(CharSequence content, Throwable error) {
        if (this.isDebugEnabled()) {
            this.print("debug", content, error);
        }
    }

    @Override
    public void debug(Throwable error) {
        if (this.isDebugEnabled()) {
            this.print("debug", error);
        }
    }

    @Override
    public void info(CharSequence content) {
        if (this.isInfoEnabled()) {
            this.print("info", content);
        }
    }

    @Override
    public void info(CharSequence content, Throwable error) {
        if (this.isInfoEnabled()) {
            this.print("info", content, error);
        }
    }

    @Override
    public void info(Throwable error) {
        if (this.isInfoEnabled()) {
            this.print("info", error);
        }
    }

    @Override
    public void warn(CharSequence content) {
        if (this.isWarnEnabled()) {
            this.print("warn", content);
        }
    }

    @Override
    public void warn(CharSequence content, Throwable error) {
        if (this.isWarnEnabled()) {
            this.print("warn", content, error);
        }
    }

    @Override
    public void warn(Throwable error) {
        if (this.isWarnEnabled()) {
            this.print("warn", error);
        }
    }

    @Override
    public void error(CharSequence content) {
        if (this.isErrorEnabled()) {
            System.err.println("[error] " + ((Object)content).toString());
        }
    }

    @Override
    public void error(CharSequence content, Throwable error) {
        if (this.isErrorEnabled()) {
            StringWriter sWriter = new StringWriter();
            PrintWriter pWriter = new PrintWriter(sWriter);
            error.printStackTrace(pWriter);
            System.err.println("[error] " + ((Object)content).toString() + EOL + EOL + sWriter.toString());
        }
    }

    @Override
    public void error(Throwable error) {
        if (this.isErrorEnabled()) {
            StringWriter sWriter = new StringWriter();
            PrintWriter pWriter = new PrintWriter(sWriter);
            error.printStackTrace(pWriter);
            System.err.println("[error] " + sWriter.toString());
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.currentLevel <= 0;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.currentLevel <= 1;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.currentLevel <= 2;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.currentLevel <= 3;
    }

    private void print(String prefix, CharSequence content) {
        System.out.println("[" + prefix + "] " + ((Object)content).toString());
    }

    private void print(String prefix, Throwable error) {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        error.printStackTrace(pWriter);
        System.out.println("[" + prefix + "] " + sWriter.toString());
    }

    private void print(String prefix, CharSequence content, Throwable error) {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        error.printStackTrace(pWriter);
        System.out.println("[" + prefix + "] " + ((Object)content).toString() + EOL + EOL + sWriter.toString());
    }
}

