/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.swing.text.AttributeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.module.markdown.LastTwoLinesBufferingWriter;
import org.apache.maven.doxia.module.markdown.MarkdownMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractTextSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.HtmlTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownSink
extends AbstractTextSink
implements MarkdownMarkup {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkdownSink.class);
    private StringBuilder buffer;
    private Collection<String> authors;
    private String title;
    private String date;
    private String linkName;
    private boolean tableHeaderCellFlag;
    private int cellCount;
    private List<Integer> cellJustif;
    private boolean isFirstTableRow;
    private final PrintWriter writer;
    private final LastTwoLinesBufferingWriter bufferingWriter;
    protected Queue<Queue<String>> inlineStack = Collections.asLifoQueue(new LinkedList());
    protected Queue<ElementContext> elementContextStack = Collections.asLifoQueue(new LinkedList());
    private String figureSrc;

    protected MarkdownSink(Writer writer) {
        this.bufferingWriter = new LastTwoLinesBufferingWriter(writer);
        this.writer = new PrintWriter(this.bufferingWriter);
        this.init();
    }

    private void endContext(ElementContext expectedContext) {
        ElementContext removedContext = this.elementContextStack.remove();
        if (removedContext != expectedContext) {
            throw new IllegalStateException("Unexpected context " + (Object)((Object)removedContext) + ", expected " + (Object)((Object)expectedContext));
        }
        if (removedContext.isBlock()) {
            this.endBlock(removedContext.requiresSurroundingByBlankLines);
        }
    }

    private void startContext(ElementContext newContext) {
        if (newContext.isBlock()) {
            this.startBlock(newContext.requiresSurroundingByBlankLines);
        }
        this.elementContextStack.add(newContext);
    }

    private void ensureBeginningOfLine() {
        if (!this.bufferingWriter.isWriterAtStartOfNewLine()) {
            this.writeUnescaped(EOL);
        }
    }

    private void ensureBlankLine() {
        if (!this.bufferingWriter.isWriterAfterBlankLine()) {
            if (this.bufferingWriter.isWriterAtStartOfNewLine()) {
                this.writeUnescaped(EOL);
            } else {
                this.writeUnescaped(BLANK_LINE);
            }
        }
    }

    private void startBlock(boolean requireBlankLine) {
        if (requireBlankLine) {
            this.ensureBlankLine();
        } else {
            this.ensureBeginningOfLine();
        }
        this.writeUnescaped(this.getContainerLinePrefixes());
    }

    private void endBlock(boolean requireBlankLine) {
        if (requireBlankLine) {
            this.ensureBlankLine();
        } else {
            this.ensureBeginningOfLine();
        }
    }

    private String getContainerLinePrefixes() {
        StringBuilder prefix = new StringBuilder();
        this.elementContextStack.stream().filter(c -> c.prefix.length() > 0).forEachOrdered(c -> prefix.insert(0, c.prefix));
        return prefix.toString();
    }

    protected StringBuilder getBuffer() {
        return this.buffer;
    }

    protected void init() {
        super.init();
        this.resetBuffer();
        this.authors = new LinkedList<String>();
        this.title = null;
        this.date = null;
        this.linkName = null;
        this.tableHeaderCellFlag = false;
        this.cellCount = 0;
        this.cellJustif = null;
        this.elementContextStack.clear();
        this.inlineStack.clear();
        this.elementContextStack.add(ElementContext.BODY);
    }

    protected void resetBuffer() {
        this.buffer = new StringBuilder();
    }

    public void head(SinkEventAttributes attributes) {
        this.init();
        this.endContext(ElementContext.BODY);
        this.elementContextStack.add(ElementContext.HEAD);
    }

    public void head_() {
        this.endContext(ElementContext.HEAD);
        if (this.title == null && this.authors.isEmpty() && this.date == null) {
            return;
        }
        this.writeUnescaped(METADATA_MARKUP + EOL);
        if (this.title != null) {
            this.writeUnescaped("title: " + this.title + EOL);
        }
        if (!this.authors.isEmpty()) {
            this.writeUnescaped("author: " + EOL);
            for (String author : this.authors) {
                this.writeUnescaped("  - " + author + EOL);
            }
        }
        if (this.date != null) {
            this.writeUnescaped("date: " + this.date + EOL);
        }
        this.writeUnescaped(METADATA_MARKUP + BLANK_LINE);
    }

    public void body(SinkEventAttributes attributes) {
        this.elementContextStack.add(ElementContext.BODY);
    }

    public void body_() {
        this.endContext(ElementContext.BODY);
    }

    public void title_() {
        if (this.buffer.length() > 0) {
            this.title = this.buffer.toString();
            this.resetBuffer();
        }
    }

    public void author_() {
        if (this.buffer.length() > 0) {
            this.authors.add(this.buffer.toString());
            this.resetBuffer();
        }
    }

    public void date_() {
        if (this.buffer.length() > 0) {
            this.date = this.buffer.toString();
            this.resetBuffer();
        }
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        if (level > 0) {
            this.writeUnescaped(StringUtils.repeat((String)"#", (int)level) + ' ');
        }
    }

    public void sectionTitle_(int level) {
        if (level > 0) {
            this.ensureBlankLine();
        }
    }

    public void list_() {
        this.ensureBlankLine();
    }

    public void listItem(SinkEventAttributes attributes) {
        this.startContext(ElementContext.LIST_ITEM);
        this.writeUnescaped("- ");
    }

    public void listItem_() {
        this.endContext(ElementContext.LIST_ITEM);
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        if (numbering != 0) {
            LOGGER.warn("{}Markdown only supports numbered item with decimal style ({}) but requested was style {}, falling back to decimal style", new Object[]{this.getLocationLogPrefix(), 0, numbering});
        }
    }

    public void numberedList_() {
        this.writeUnescaped(EOL);
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        this.startContext(ElementContext.LIST_ITEM);
        this.writeUnescaped("1. ");
    }

    public void numberedListItem_() {
        this.listItem_();
    }

    public void definitionList(SinkEventAttributes attributes) {
        LOGGER.warn("{}Definition list not natively supported in Markdown, rendering HTML instead", (Object)this.getLocationLogPrefix());
        this.ensureBlankLine();
        this.writeUnescaped("<dl>" + EOL);
    }

    public void definitionList_() {
        this.writeUnescaped("</dl>" + BLANK_LINE);
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.writeUnescaped("<dt>");
    }

    public void definedTerm_() {
        this.writeUnescaped("</dt>" + EOL);
    }

    public void definition(SinkEventAttributes attributes) {
        this.writeUnescaped("<dd>");
    }

    public void definition_() {
        this.writeUnescaped("</dd>" + EOL);
    }

    public void pageBreak() {
        LOGGER.warn("Ignoring unsupported page break in Markdown");
    }

    public void paragraph(SinkEventAttributes attributes) {
        if (this.elementContextStack.element().isContainer()) {
            this.ensureBlankLine();
            this.writeUnescaped(this.getContainerLinePrefixes());
        }
    }

    public void paragraph_() {
        if (this.elementContextStack.element().isContainer()) {
            this.ensureBlankLine();
        }
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.startContext(ElementContext.CODE_BLOCK);
        this.writeUnescaped("```" + EOL);
        this.writeUnescaped(this.getContainerLinePrefixes());
    }

    public void verbatim_() {
        this.ensureBeginningOfLine();
        this.writeUnescaped(this.getContainerLinePrefixes());
        this.writeUnescaped("```" + BLANK_LINE);
        this.endContext(ElementContext.CODE_BLOCK);
    }

    public void blockquote(SinkEventAttributes attributes) {
        this.startContext(ElementContext.BLOCKQUOTE);
        this.writeUnescaped("> ");
    }

    public void blockquote_() {
        this.endContext(ElementContext.BLOCKQUOTE);
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.ensureBeginningOfLine();
        this.writeUnescaped("***" + BLANK_LINE);
        this.writeUnescaped(this.getContainerLinePrefixes());
    }

    public void table(SinkEventAttributes attributes) {
        this.ensureBlankLine();
        this.writeUnescaped(this.getContainerLinePrefixes());
    }

    public void tableRows(int[] justification, boolean grid) {
        this.cellJustif = justification != null ? (List<Object>)Arrays.stream(justification).boxed().collect(Collectors.toCollection(ArrayList::new)) : new ArrayList<Integer>();
        this.isFirstTableRow = true;
    }

    public void tableRows_() {
        this.cellJustif = null;
    }

    public void tableRow(SinkEventAttributes attributes) {
        this.cellCount = 0;
    }

    public void tableRow_() {
        if (this.isFirstTableRow && !this.tableHeaderCellFlag) {
            this.writeEmptyTableHeader();
            this.writeTableDelimiterRow();
            this.tableHeaderCellFlag = false;
            this.isFirstTableRow = false;
        }
        this.writeUnescaped(TABLE_ROW_PREFIX);
        this.writeUnescaped(this.buffer.toString());
        this.resetBuffer();
        this.writeUnescaped(EOL);
        if (this.isFirstTableRow) {
            this.writeTableDelimiterRow();
            this.isFirstTableRow = false;
        }
        this.cellCount = 0;
    }

    private void writeEmptyTableHeader() {
        this.writeUnescaped(TABLE_ROW_PREFIX);
        for (int i = 0; i < this.cellCount; ++i) {
            this.writeUnescaped(StringUtils.repeat((String)String.valueOf(' '), (int)3) + TABLE_CELL_SEPARATOR_MARKUP);
        }
        this.writeUnescaped(EOL);
        this.writeUnescaped(this.getContainerLinePrefixes());
    }

    private void writeTableDelimiterRow() {
        this.writeUnescaped(TABLE_ROW_PREFIX);
        int justification = 1;
        for (int i = 0; i < this.cellCount; ++i) {
            if (this.cellJustif != null && this.cellJustif.size() > i) {
                justification = this.cellJustif.get(i);
            }
            switch (justification) {
                case 2: {
                    this.writeUnescaped(TABLE_COL_RIGHT_ALIGNED_MARKUP);
                    break;
                }
                case 0: {
                    this.writeUnescaped(TABLE_COL_CENTER_ALIGNED_MARKUP);
                    break;
                }
                default: {
                    this.writeUnescaped(TABLE_COL_LEFT_ALIGNED_MARKUP);
                }
            }
            this.writeUnescaped(TABLE_CELL_SEPARATOR_MARKUP);
        }
        this.writeUnescaped(EOL);
    }

    public void tableCell(SinkEventAttributes attributes) {
        int cellJustification;
        if (attributes != null && (cellJustification = attributes.containsAttributes((AttributeSet)SinkEventAttributeSet.LEFT) ? 1 : (attributes.containsAttributes((AttributeSet)SinkEventAttributeSet.RIGHT) ? 2 : (attributes.containsAttributes((AttributeSet)SinkEventAttributeSet.CENTER) ? 0 : -1))) > -1) {
            if (this.cellJustif.size() > this.cellCount) {
                this.cellJustif.set(this.cellCount, cellJustification);
            } else if (this.cellJustif.size() == this.cellCount) {
                this.cellJustif.add(cellJustification);
            } else {
                for (int precedingCol = this.cellJustif.size(); precedingCol < this.cellCount; ++precedingCol) {
                    this.cellJustif.add(1);
                }
                this.cellJustif.add(cellJustification);
            }
        }
        this.elementContextStack.add(ElementContext.TABLE_CELL);
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableCell(attributes);
        this.tableHeaderCellFlag = true;
    }

    public void tableCell_() {
        this.endTableCell();
    }

    public void tableHeaderCell_() {
        this.endTableCell();
    }

    private void endTableCell() {
        this.endContext(ElementContext.TABLE_CELL);
        this.buffer.append(TABLE_CELL_SEPARATOR_MARKUP);
        ++this.cellCount;
    }

    public void tableCaption(SinkEventAttributes attributes) {
        this.elementContextStack.add(ElementContext.TABLE_CAPTION);
    }

    public void tableCaption_() {
        this.endContext(ElementContext.TABLE_CAPTION);
    }

    public void figure(SinkEventAttributes attributes) {
        this.figureSrc = null;
        this.elementContextStack.add(ElementContext.FIGURE);
    }

    public void figureGraphics(String name, SinkEventAttributes attributes) {
        this.figureSrc = MarkdownSink.escapeMarkdown(name);
        if (this.elementContextStack.peek() != ElementContext.FIGURE) {
            Object alt = attributes.getAttribute((Object)"alt");
            if (alt == null) {
                alt = "";
            }
            this.writeImage(MarkdownSink.escapeMarkdown(alt.toString()), name);
        }
    }

    public void figure_() {
        this.endContext(ElementContext.FIGURE);
        this.writeImage(this.buffer.toString(), this.figureSrc);
    }

    private void writeImage(String alt, String src) {
        this.writeUnescaped("![");
        this.writeUnescaped(alt);
        this.writeUnescaped("](" + src + ")");
    }

    public void anchor(String name, SinkEventAttributes attributes) {
    }

    public void anchor_() {
    }

    public void link(String name, SinkEventAttributes attributes) {
        this.writeUnescaped("[");
        this.linkName = name;
    }

    public void link_() {
        this.writeUnescaped("](");
        this.text(this.linkName.startsWith("#") ? this.linkName.substring(1) : this.linkName);
        this.writeUnescaped(")");
        this.linkName = null;
    }

    public void inline(SinkEventAttributes attributes) {
        Queue<String> endMarkups = Collections.asLifoQueue(new LinkedList());
        if (attributes != null && this.elementContextStack.element() != ElementContext.CODE_BLOCK && this.elementContextStack.element() != ElementContext.CODE_SPAN) {
            if (attributes.containsAttribute((Object)"semantics", (Object)"code") || attributes.containsAttribute((Object)"semantics", (Object)"monospaced") || attributes.containsAttribute((Object)"style", (Object)"monospaced")) {
                this.writeUnescaped("`");
                endMarkups.add("`");
                this.elementContextStack.add(ElementContext.CODE_SPAN);
            } else {
                if (attributes.containsAttribute((Object)"semantics", (Object)"em") || attributes.containsAttribute((Object)"semantics", (Object)"italic") || attributes.containsAttribute((Object)"style", (Object)"italic")) {
                    this.writeUnescaped("_");
                    endMarkups.add("_");
                }
                if (attributes.containsAttribute((Object)"semantics", (Object)"strong") || attributes.containsAttribute((Object)"semantics", (Object)"bold") || attributes.containsAttribute((Object)"style", (Object)"bold")) {
                    this.writeUnescaped("**");
                    endMarkups.add("**");
                }
            }
        }
        this.inlineStack.add(endMarkups);
    }

    public void inline_() {
        for (String endMarkup : this.inlineStack.remove()) {
            if (endMarkup.equals("`")) {
                this.endContext(ElementContext.CODE_SPAN);
            }
            this.writeUnescaped(endMarkup);
        }
    }

    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    public void italic_() {
        this.inline_();
    }

    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    public void bold_() {
        this.inline_();
    }

    public void monospaced() {
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    public void monospaced_() {
        this.inline_();
    }

    public void lineBreak(SinkEventAttributes attributes) {
        if (this.elementContextStack.element() == ElementContext.CODE_BLOCK) {
            this.writeUnescaped(EOL);
        } else {
            this.writeUnescaped("  " + EOL);
        }
        this.writeUnescaped(this.getContainerLinePrefixes());
    }

    public void nonBreakingSpace() {
        this.writeUnescaped("&nbsp;");
    }

    public void text(String text, SinkEventAttributes attributes) {
        ElementContext currentContext;
        if (attributes != null) {
            this.inline(attributes);
        }
        if ((currentContext = this.elementContextStack.element()) == ElementContext.TABLE_CAPTION) {
            LOGGER.warn("{}Ignoring unsupported table caption in Markdown", (Object)this.getLocationLogPrefix());
        } else {
            String unifiedText = currentContext.escape(MarkdownSink.unifyEOLs((String)text));
            this.writeUnescaped(unifiedText);
        }
        if (attributes != null) {
            this.inline_();
        }
    }

    public void rawText(String text) {
        this.writeUnescaped(text);
    }

    public void comment(String comment) {
        this.rawText("<!-- " + comment + " -->");
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        LOGGER.warn("{}Unknown Sink event '" + name + "', ignoring!", (Object)this.getLocationLogPrefix());
    }

    private boolean requiresBuffering() {
        return this.elementContextStack.stream().anyMatch(c -> c.requiresBuffering);
    }

    protected void writeUnescaped(String text) {
        if (this.requiresBuffering()) {
            this.buffer.append(text);
        } else {
            this.writer.write(text);
        }
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
        this.init();
    }

    private static String escapeMarkdown(String text) {
        if (text == null) {
            return "";
        }
        text = HtmlTools.escapeHTML((String)text, (boolean)true);
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        block3: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '_': 
                case '`': 
                case '{': 
                case '}': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block3;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private static String escapeForTableCell(String text) {
        return MarkdownSink.escapeMarkdown(text).replace("|", "\\|");
    }

    static enum ElementContext {
        HEAD("head", Type.GENERIC_CONTAINER, null, true),
        BODY("body", Type.GENERIC_CONTAINER, x$0 -> MarkdownSink.access$000(x$0)),
        FIGURE("", Type.INLINE, x$0 -> MarkdownSink.access$000(x$0), true),
        CODE_BLOCK("code block", Type.LEAF_BLOCK, null, false),
        CODE_SPAN("code span", Type.INLINE, null),
        TABLE_CAPTION("table caption", Type.INLINE, x$0 -> MarkdownSink.access$000(x$0)),
        TABLE_CELL("table cell", Type.LEAF_BLOCK, x$0 -> MarkdownSink.access$100(x$0), true),
        LIST_ITEM("list item", Type.CONTAINER_BLOCK, x$0 -> MarkdownSink.access$000(x$0), false, MarkdownMarkup.INDENT),
        BLOCKQUOTE("blockquote", Type.CONTAINER_BLOCK, x$0 -> MarkdownSink.access$000(x$0), false, "> ");

        final String name;
        final Type type;
        final UnaryOperator<String> escapeFunction;
        final boolean requiresBuffering;
        final String prefix;
        final boolean requiresSurroundingByBlankLines;

        private ElementContext(String name, Type type, UnaryOperator<String> escapeFunction) {
            this(name, type, escapeFunction, false);
        }

        private ElementContext(String name, Type type, UnaryOperator<String> escapeFunction, boolean requiresBuffering) {
            this(name, type, escapeFunction, requiresBuffering, "");
        }

        private ElementContext(String name, Type type, UnaryOperator<String> escapeFunction, boolean requiresBuffering, String prefix) {
            this(name, type, escapeFunction, requiresBuffering, prefix, false);
        }

        private ElementContext(String name, Type type, UnaryOperator<String> escapeFunction, boolean requiresBuffering, String prefix, boolean requiresSurroundingByBlankLines) {
            this.name = name;
            this.type = type;
            this.escapeFunction = escapeFunction;
            this.requiresBuffering = requiresBuffering;
            if (type != Type.CONTAINER_BLOCK && prefix.length() != 0) {
                throw new IllegalArgumentException("Only container blocks may define a prefix (for nesting)");
            }
            this.prefix = prefix;
            this.requiresSurroundingByBlankLines = requiresSurroundingByBlankLines;
        }

        String escape(String text) {
            if (this.escapeFunction == null) {
                return text;
            }
            return (String)this.escapeFunction.apply(text);
        }

        boolean isBlock() {
            return this.type == Type.CONTAINER_BLOCK || this.type == Type.LEAF_BLOCK;
        }

        boolean isContainer() {
            return this.type == Type.CONTAINER_BLOCK || this.type == Type.GENERIC_CONTAINER;
        }

        static enum Type {
            GENERIC_CONTAINER,
            CONTAINER_BLOCK,
            LEAF_BLOCK,
            INLINE;

        }
    }
}

