/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer.sink;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.module.xhtml.XhtmlSink;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class SiteRendererSink
extends XhtmlSink
implements Sink,
org.codehaus.doxia.sink.Sink {
    private String date = "";
    private String title = "";
    private List authors = new ArrayList();
    private boolean sectionHasID;
    private final Writer writer;
    private RenderingContext renderingContext;

    public SiteRendererSink(RenderingContext renderingContext) {
        this(new StringWriter(), renderingContext);
    }

    private SiteRendererSink(StringWriter writer, RenderingContext renderingContext) {
        super((Writer)writer);
        this.writer = writer;
        this.renderingContext = renderingContext;
    }

    public void title_() {
        if (this.getTextBuffer().length() > 0) {
            this.title = this.getTextBuffer().toString();
        }
        this.resetTextBuffer();
    }

    public void title() {
    }

    public String getTitle() {
        return this.title;
    }

    public void author_() {
        if (this.getTextBuffer().length() > 0) {
            this.authors.add(this.getTextBuffer().toString());
        }
        this.resetTextBuffer();
    }

    public List getAuthors() {
        return this.authors;
    }

    public void date_() {
        if (this.getTextBuffer().length() > 0) {
            this.date = this.getTextBuffer().toString();
        }
        this.resetTextBuffer();
    }

    public String getDate() {
        return this.date;
    }

    public void body_() {
    }

    public void body() {
    }

    public String getBody() {
        return this.writer.toString();
    }

    public void head_() {
        this.setHeadFlag(false);
    }

    public void head() {
        this.setHeadFlag(true);
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        if (level == 1 || level == 2) {
            this.setHeadFlag(true);
            this.sectionHasID = attributes != null && attributes.isDefined((Object)HTML.Attribute.ID.toString());
        } else {
            super.sectionTitle(level, attributes);
        }
    }

    public void sectionTitle_(int level) {
        if (level == 1 || level == 2) {
            String sectionTitle = "";
            if (this.getTextBuffer().length() > 0) {
                sectionTitle = this.getTextBuffer().toString();
            }
            this.resetTextBuffer();
            this.setHeadFlag(false);
            this.writeStartTag(level == 1 ? HTML.Tag.H2 : HTML.Tag.H3);
            if (!this.sectionHasID) {
                this.anchor(HtmlTools.encodeId((String)sectionTitle));
                this.anchor_();
            } else {
                this.sectionHasID = false;
            }
            this.text(sectionTitle);
            this.writeEndTag(level == 1 ? HTML.Tag.H2 : HTML.Tag.H3);
        } else {
            super.sectionTitle_(level);
        }
    }

    public void sectionTitle1() {
        this.sectionTitle(1, null);
    }

    public void sectionTitle1_() {
        this.sectionTitle_(1);
    }

    public void sectionTitle2() {
        this.sectionTitle(2, null);
    }

    public void sectionTitle2_() {
        this.sectionTitle_(2);
    }

    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }

    protected void write(String text) {
        if (this.renderingContext != null) {
            String relativePathToBasedir = this.renderingContext.getRelativePath();
            text = relativePathToBasedir == null ? StringUtils.replace((String)text, (String)"$relativePath", (String)".") : StringUtils.replace((String)text, (String)"$relativePath", (String)relativePathToBasedir);
        }
        super.write(text);
    }
}

