/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

public class BannedRepositories
extends AbstractNonCacheableEnforcerRule {
    private List<String> bannedRepositories = Collections.emptyList();
    private List<String> bannedPluginRepositories = Collections.emptyList();
    private List<String> allowedRepositories = Collections.emptyList();
    private List<String> allowedPluginRepositories = Collections.emptyList();

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            List<ArtifactRepository> resultBannedRepos = this.checkRepositories(project.getRemoteArtifactRepositories(), this.allowedRepositories, this.bannedRepositories);
            List<ArtifactRepository> resultBannedPluginRepos = this.checkRepositories(project.getPluginArtifactRepositories(), this.allowedPluginRepositories, this.bannedPluginRepositories);
            String repoErrMsg = this.populateErrorMessage(resultBannedRepos, " ");
            String pluginRepoErrMsg = this.populateErrorMessage(resultBannedPluginRepos, " plugin ");
            String errMsg = repoErrMsg + pluginRepoErrMsg;
            if (errMsg != null && !StringUtils.isEmpty((String)errMsg.toString())) {
                throw new EnforcerRuleException(errMsg.toString());
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
    }

    protected void setBannedRepositories(List<String> bannedRepositories) {
        this.bannedRepositories = bannedRepositories;
    }

    protected void setBannedPluginRepositories(List<String> bannedPluginRepositories) {
        this.bannedPluginRepositories = bannedPluginRepositories;
    }

    protected void setAllowedRepositories(List<String> allowedRepositories) {
        this.allowedRepositories = allowedRepositories;
    }

    protected void setAllowedPluginRepositories(List<String> allowedPluginRepositories) {
        this.allowedPluginRepositories = allowedPluginRepositories;
    }

    private List<ArtifactRepository> checkRepositories(List<ArtifactRepository> repositories, List<String> includes, List<String> excludes) {
        ArrayList<ArtifactRepository> bannedRepos = new ArrayList<ArtifactRepository>();
        for (ArtifactRepository repo : repositories) {
            String url = repo.getUrl().trim();
            if (includes.size() > 0 && !this.match(url, includes)) {
                bannedRepos.add(repo);
                continue;
            }
            if (excludes.size() <= 0 || !this.match(url, excludes)) continue;
            bannedRepos.add(repo);
        }
        return bannedRepos;
    }

    private boolean match(String url, List<String> patterns) {
        for (String pattern : patterns) {
            if (!this.match(url, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean match(String text, String pattern) {
        return text.matches(pattern.replace("?", ".?").replace("*", ".*?"));
    }

    private String populateErrorMessage(List<ArtifactRepository> resultBannedRepos, String errorMessagePrefix) {
        StringBuffer errMsg = new StringBuffer("");
        if (!resultBannedRepos.isEmpty()) {
            errMsg.append("Current maven session contains banned" + errorMessagePrefix + "repository urls, please double check your pom or settings.xml:\n" + this.getRepositoryUrlString(resultBannedRepos) + "\n\n");
        }
        return errMsg.toString();
    }

    private String getRepositoryUrlString(List<ArtifactRepository> resultBannedRepos) {
        StringBuffer urls = new StringBuffer("");
        for (ArtifactRepository repo : resultBannedRepos) {
            urls.append(repo.getId() + " - " + repo.getUrl() + "\n");
        }
        return urls.toString();
    }
}

