/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

public class ReactorModuleConvergence
extends AbstractNonCacheableEnforcerRule {
    private boolean ignoreModuleDependencies = false;
    private Log logger;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenSession session;
        this.logger = helper.getLog();
        try {
            session = (MavenSession)helper.evaluate("${session}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenSession: ", (Exception)((Object)eee));
        }
        List sortedProjects = session.getSortedProjects();
        if (sortedProjects != null && !sortedProjects.isEmpty()) {
            this.checkReactor(sortedProjects);
            this.checkParentsInReactor(sortedProjects);
            this.checkMissingParentsInReactor(sortedProjects);
            this.checkParentsPartOfTheReactor(sortedProjects);
            if (!this.isIgnoreModuleDependencies()) {
                this.checkDependenciesWithinReactor(sortedProjects);
            }
        }
    }

    private void checkParentsPartOfTheReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        List<MavenProject> parentsWhichAreNotPartOfTheReactor = this.existParentsWhichAreNotPartOfTheReactor(sortedProjects);
        if (!parentsWhichAreNotPartOfTheReactor.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(SystemUtils.LINE_SEPARATOR);
            this.addMessageIfExist(sb);
            for (MavenProject mavenProject : parentsWhichAreNotPartOfTheReactor) {
                sb.append(" module: ");
                sb.append(mavenProject.getId());
                sb.append(SystemUtils.LINE_SEPARATOR);
            }
            throw new EnforcerRuleException("Module parents have been found which could not be found in the reactor." + sb.toString());
        }
    }

    private void checkMissingParentsInReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        List<MavenProject> modulesWithoutParentsInReactor = this.existModulesWithoutParentsInReactor(sortedProjects);
        if (!modulesWithoutParentsInReactor.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(SystemUtils.LINE_SEPARATOR);
            this.addMessageIfExist(sb);
            for (MavenProject mavenProject : modulesWithoutParentsInReactor) {
                sb.append(" module: ");
                sb.append(mavenProject.getId());
                sb.append(SystemUtils.LINE_SEPARATOR);
            }
            throw new EnforcerRuleException("Reactor contains modules without parents." + sb.toString());
        }
    }

    private void checkDependenciesWithinReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        String reactorVersion = sortedProjects.get(0).getVersion();
        Map<MavenProject, List<Dependency>> areThereDependenciesWhichAreNotPartOfTheReactor = this.areThereDependenciesWhichAreNotPartOfTheReactor(reactorVersion, sortedProjects);
        if (!areThereDependenciesWhichAreNotPartOfTheReactor.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(SystemUtils.LINE_SEPARATOR);
            this.addMessageIfExist(sb);
            for (Map.Entry<MavenProject, List<Dependency>> item : areThereDependenciesWhichAreNotPartOfTheReactor.entrySet()) {
                sb.append(" module: ");
                sb.append(item.getKey().getId());
                sb.append(SystemUtils.LINE_SEPARATOR);
                for (Dependency dependency : item.getValue()) {
                    String id = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
                    sb.append("    dependency: ");
                    sb.append(id);
                    sb.append(SystemUtils.LINE_SEPARATOR);
                }
            }
            throw new EnforcerRuleException("Reactor modules contains dependencies which do not reference the reactor." + sb.toString());
        }
    }

    private void checkParentsInReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        String reactorVersion = sortedProjects.get(0).getVersion();
        List<MavenProject> areParentsFromTheReactor = this.areParentsFromTheReactor(reactorVersion, sortedProjects);
        if (!areParentsFromTheReactor.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(SystemUtils.LINE_SEPARATOR);
            this.addMessageIfExist(sb);
            for (MavenProject mavenProject : areParentsFromTheReactor) {
                sb.append(" --> ");
                sb.append(mavenProject.getId());
                sb.append(" parent:");
                sb.append(mavenProject.getParent().getId());
                sb.append(SystemUtils.LINE_SEPARATOR);
            }
            throw new EnforcerRuleException("Reactor modules have parents which contain a wrong version." + sb.toString());
        }
    }

    private void checkReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        List<MavenProject> consistenceCheckResult = this.isReactorVersionConsistent(sortedProjects);
        if (!consistenceCheckResult.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(SystemUtils.LINE_SEPARATOR);
            this.addMessageIfExist(sb);
            for (MavenProject mavenProject : consistenceCheckResult) {
                sb.append(" --> ");
                sb.append(mavenProject.getId());
                sb.append(SystemUtils.LINE_SEPARATOR);
            }
            throw new EnforcerRuleException("The reactor contains different versions." + sb.toString());
        }
    }

    private List<MavenProject> areParentsFromTheReactor(String reactorVersion, List<MavenProject> sortedProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject mavenProject : sortedProjects) {
            MavenProject parent;
            this.logger.debug((CharSequence)("Project: " + mavenProject.getId()));
            if (!this.hasParent(mavenProject) || mavenProject.isExecutionRoot() || reactorVersion.equals((parent = mavenProject.getParent()).getVersion())) continue;
            this.logger.debug((CharSequence)("The project: " + mavenProject.getId() + " has a parent which version does not match the other elements in reactor"));
            result.add(mavenProject);
        }
        return result;
    }

    private List<MavenProject> existParentsWhichAreNotPartOfTheReactor(List<MavenProject> sortedProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject mavenProject : sortedProjects) {
            MavenProject parent;
            this.logger.debug((CharSequence)("Project: " + mavenProject.getId()));
            if (!this.hasParent(mavenProject) || mavenProject.isExecutionRoot() || this.isProjectPartOfTheReactor(parent = mavenProject.getParent(), sortedProjects)) continue;
            result.add(mavenProject);
        }
        return result;
    }

    private boolean isProjectPartOfTheReactor(MavenProject project, List<MavenProject> sortedProjects) {
        return this.isGAPartOfTheReactor(project.getGroupId(), project.getArtifactId(), sortedProjects);
    }

    private boolean isDependencyPartOfTheReactor(Dependency dependency, List<MavenProject> sortedProjects) {
        return this.isGAPartOfTheReactor(dependency.getGroupId(), dependency.getArtifactId(), sortedProjects);
    }

    private boolean isGAPartOfTheReactor(String groupId, String artifactId, List<MavenProject> sortedProjects) {
        boolean result = false;
        for (MavenProject mavenProject : sortedProjects) {
            String projectId;
            String parentId = groupId + ":" + artifactId;
            if (!parentId.equals(projectId = mavenProject.getGroupId() + ":" + mavenProject.getArtifactId())) continue;
            result = true;
        }
        return result;
    }

    private List<MavenProject> existModulesWithoutParentsInReactor(List<MavenProject> sortedProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject mavenProject : sortedProjects) {
            this.logger.debug((CharSequence)("Project: " + mavenProject.getId()));
            if (this.hasParent(mavenProject)) continue;
            if (mavenProject.isExecutionRoot()) {
                this.logger.debug((CharSequence)"The root does not need having a parent.");
                continue;
            }
            this.logger.debug((CharSequence)("The module: " + mavenProject.getId() + " has no parent."));
            result.add(mavenProject);
        }
        return result;
    }

    private void addDep(Map<MavenProject, List<Dependency>> result, MavenProject project, Dependency dependency) {
        if (result.containsKey(project)) {
            List<Dependency> list = result.get(project);
            if (list == null) {
                list = new ArrayList<Dependency>();
            }
            list.add(dependency);
            result.put(project, list);
        } else {
            ArrayList<Dependency> list = new ArrayList<Dependency>();
            list.add(dependency);
            result.put(project, list);
        }
    }

    private Map<MavenProject, List<Dependency>> areThereDependenciesWhichAreNotPartOfTheReactor(String reactorVersion, List<MavenProject> sortedProjects) {
        HashMap<MavenProject, List<Dependency>> result = new HashMap<MavenProject, List<Dependency>>();
        for (MavenProject mavenProject : sortedProjects) {
            this.logger.debug((CharSequence)("Project: " + mavenProject.getId()));
            List dependencies = mavenProject.getDependencies();
            if (!this.hasDependencies(dependencies)) continue;
            for (Dependency dependency : dependencies) {
                this.logger.debug((CharSequence)(" -> Dep:" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion()));
                if (!this.isDependencyPartOfTheReactor(dependency, sortedProjects) || dependency.getVersion().equals(reactorVersion)) continue;
                this.addDep(result, mavenProject, dependency);
            }
        }
        return result;
    }

    private List<MavenProject> isReactorVersionConsistent(List<MavenProject> projectList) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        if (projectList != null && !projectList.isEmpty()) {
            String version = projectList.get(0).getVersion();
            this.logger.debug((CharSequence)("First version:" + version));
            for (MavenProject mavenProject : projectList) {
                this.logger.debug((CharSequence)(" -> checking " + mavenProject.getId()));
                if (version.equals(mavenProject.getVersion())) continue;
                result.add(mavenProject);
            }
        }
        return result;
    }

    private boolean hasDependencies(List<Dependency> dependencies) {
        return dependencies != null && !dependencies.isEmpty();
    }

    private boolean hasParent(MavenProject mavenProject) {
        return mavenProject.getParent() != null;
    }

    public boolean isIgnoreModuleDependencies() {
        return this.ignoreModuleDependencies;
    }

    public void setIgnoreModuleDependencies(boolean ignoreModuleDependencies) {
        this.ignoreModuleDependencies = ignoreModuleDependencies;
    }

    private void addMessageIfExist(StringBuilder sb) {
        if (!StringUtils.isEmpty((String)this.getMessage())) {
            sb.append(this.getMessage());
            sb.append(SystemUtils.LINE_SEPARATOR);
        }
    }
}

